<?php $__env->startSection('title', __('lang.start now')); ?>
<?php $__env->startSection('content'); ?>
    <!-- HEADER AREA -->
    <?php echo $__env->make('Frontend.Includes.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- HEADER AREA END -->
    <div class="site-content">

        <div class="container-fluid">
            <div class="item-efftect">
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
            </div>
        </div>

        <!--=================================
                                      Page Header -->
        <div class="inner-header bg-holder" data-bg="<?php echo e(asset('front/images/head.jpg')); ?>">
            <div class="container">
                <div class="row  justify-content-center">
                    <div class="col-md-12 text-center">
                        <h1 class="title"><?php echo e(__('lang.start now')); ?></h1>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-wrapper">

            <?php
                $hsetting = App\Models\Home_setting::select(
                    'section10_subtitle',
                    'section10_title',
                    'section10_title_en',
                    'section10_subtitle_en',
                    'section9_subtitle',
                    'section9_title',
                    'section9_title_en',
                    'section9_subtitle_en',
                    'phone',
                    'email',
                    'address',
                    'whatsapp',
                    'facebook',
                    'instagram',
                    'linkedin',
                    'twitter',
                )->first();
            ?>
            <section class="space-ptb">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-10 col-xl-8">
                            <div class="form-wrapper form-box bg-black mt-5 mt-lg-0 z-index-2">
                                <div class="section-title">
                                    <h4 class="title mb-0">
                                        <?php echo e(__('lang.We welcome your interest in our services! Please fill out the following form carefully so that our specialized teams can review your request and provide the best solutions to suit your needs.')); ?>

                                    </h4>
                                </div>
                                <form id="orderForm" class="form-form form-style-border">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control" placeholder="<?php echo e(__('lang.Name')); ?>" maxlength="250"
                                                aria-label="Name">
                                        </div>
                                        <div class="col-sm-6">
                                            <input type="email" class="form-control" placeholder="<?php echo e(__('lang.Email')); ?>"
                                                aria-label="Email" required>
                                        </div>
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control" id="phone" maxlength="15"
                                                placeholder="<?php echo e(__('lang.Phone')); ?>" required>
                                        </div>

                                        
                                        <div class="col-sm-6">
                                            <select id="typeSelect" class="form-control" name="type">
                                                <option disabled selected><?php echo e(__('lang.Choose Type')); ?></option>
                                                <option value="service"><?php echo e(__('lang.Service')); ?></option>
                                                <option value="plan"><?php echo e(__('lang.Plan')); ?></option>
                                                <option value="consultation"><?php echo e(__('lang.Consultation')); ?></option>
                                            </select>
                                        </div>

                                        
                                        <div class="col-sm-6 d-none" id="servicesSelect">
                                            <select class="form-control" name="related_id">
                                                <option disabled selected><?php echo e(__('lang.Choose Service')); ?></option>
                                                <?php
                                                $services = App\Models\Service::select('title','title_en','id')->where('status', 1)->latest()->get();
                                                ?>
                                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($service->id); ?>"><?php echo e(app()->getLocale() == 'ar' ? $service->title : $service->title_en); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        
                                        <div class="col-sm-6 d-none" id="plansSelect">
                                            <select class="form-control" name="related_id">
                                                <option disabled selected><?php echo e(__('lang.Choose Plan')); ?></option>
                                                <?php
                                                $plans = App\Models\Plan::select('title_ar','title_en','id')->where('status', 1)->latest()->get();
                                                ?>
                                                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($plan->id); ?>"><?php echo e(app()->getLocale() == 'ar' ? $plan->title_ar : $plan->title_en); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="d-flex justify-content-center ms-sm-5 ms-0">
                                            <button type="submit" class="btn btn-effect" href="#">
                                                <span><?php echo e(__('lang.Send now')); ?></span>
                                                <!-- SVG here -->
                                            </button>
                                        </div>
                                    </div>
                                </form>

                                
                                <script>
                                    document.getElementById('typeSelect').addEventListener('change', function() {
                                        const serviceSelect = document.getElementById('servicesSelect');
                                        const planSelect = document.getElementById('plansSelect');

                                        serviceSelect.classList.add('d-none');
                                        planSelect.classList.add('d-none');

                                        if (this.value === 'service') {
                                            serviceSelect.classList.remove('d-none');
                                        } else if (this.value === 'plan') {
                                            planSelect.classList.remove('d-none');
                                        }
                                    });
                                </script>

                            </div>
                        </div>
                        <div class="col-lg-8 col-xl-4">
                            <div class="section-title pe-xxl-4 me-xxl-5">
                                <span class="sub-title"><img class="img-fluid"
                                        src="<?php echo e(asset('front/images/subtitle-icon.png')); ?>" alt="">
                                    <?php echo e(__('lang.Contact us')); ?></span>
                                <h6 class="title">
                                    <?php echo e(app()->getLocale() == 'ar' ? $hsetting->section9_title : $hsetting->section9_title_en); ?>

                                </h6>

                            </div>
                            <div class="widget widget-address-info">
                                <ul class="address-info-list address-info-2">
                                    <li><i class="icon"><img class="img-fluid"
                                                src="<?php echo e(asset('front/images/svg/address-info-headphone.svg')); ?>"
                                                alt=""></i><span class="info"><span><a
                                                    href="tel:<?php echo e($hsetting->phone); ?>"><?php echo e($hsetting->phone); ?></a> </li><br>
                                    <li><i class="icon"><img class="img-fluid"
                                                src="<?php echo e(asset('front/images/svg/address-info-email.svg')); ?>"
                                                alt=""></i><span class="info"><span><a
                                                    href="mailto:<?php echo e($hsetting->email); ?>"><?php echo e($hsetting->email); ?></a></span>24x7
                                        </span></li><br>
                                    <li><i class="icon"><img class="img-fluid"
                                                src="<?php echo e(asset('front/images/svg/address-info-contacts.svg')); ?>"
                                                alt=""></i><span class="info"><span>
                                            </span><?php echo e(app()->getLocale() == 'ar' ? $hsetting->address : $hsetting->address_en); ?>

                                        </span></li>
                                </ul>

                            </div>
                            <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                <div class="social-icons" style="display: flex; gap: 40px;">
                                    <a href="<?php echo e($hsetting->whatsapp); ?>" target="_blank" style="color: #25D366;">
                                        <i class="fab fa-whatsapp fa-lg"></i>
                                    </a>
                                    <a href="<?php echo e($hsetting->facebook); ?>" target="_blank" style="color: #3b5998;">
                                        <i class="fab fa-facebook-f fa-lg"></i>
                                    </a>
                                    <a href="<?php echo e($hsetting->twitter); ?>" target="_blank" style="color: #1DA1F2;">
                                        <i class="fab fa-twitter fa-lg"></i>
                                    </a>
                                    <a href="<?php echo e($hsetting->instagram); ?>" target="_blank" style="color: #C13584;">
                                        <i class="fab fa-instagram fa-lg"></i>
                                    </a>
                                    <a href="<?php echo e($hsetting->linkedin); ?>" target="_blank" style="color: #0077b5;">
                                        <i class="fab fa-linkedin-in fa-lg"></i>
                                    </a>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </section>
            <section class="space-small-ptb ellipse-top bg-black z-index-2">
                <div class="container">
                    <div class="row mb-lg-5">
                        <div class="col-xxl-6 col-lg-8">
                            <div class="section-title mb-lg-0">
                                <span
                                    class="sub-title"><?php echo e(app()->getLocale() == 'ar' ? $hsetting->section10_title : $hsetting->section10_title_en); ?></span>
                                <h2 class="title mb-0">
                                    <?php echo e(app()->getLocale() == 'ar' ? $hsetting->section10_subtitle : $hsetting->section10_subtitle_en); ?>

                                </h2>
                            </div>
                        </div>
                        <div class="col-xxl-6 col-lg-4 align-self-end">
                            <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                <a class="btn btn-primary" href="<?php echo e(route('front.form')); ?>">
                                    <span><?php echo e(__('lang.start now')); ?></span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                    transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <?php echo $__env->make('Frontend.Includes.Footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- FOOTER AREA END -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Frontend.Layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ivadev/public_html/resources/views/Frontend/Pages/form.blade.php ENDPATH**/ ?>