<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('المميزات')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('dash-content'); ?>
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">قائمة المميزات</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">الرئيسية</a>
                            </li>
                            <li class="breadcrumb-item"> <?php echo e(__('المميزات')); ?>

                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-header-right text-md-end col-md-3 col-12 d-md-block d-none">
            <div class="mb-1 breadcrumb-right">
                <a class="btn btn-primary create_feature"><i
                        class="fas fa-plus"></i> <?php echo e(__('اضف جديد')); ?></a>
            </div>
        </div>
    </div>
    <div class="features-list-wrapper">
        <!-- features List Items -->
        <div class="row" id="basic-table">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">قائمة المميزات</h4>
                    </div>
                    <div class="table-responsive p-3">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان </th>
                                    <th>العمليات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$index); ?></td>
                                        <td><?php echo e($feature->title_en); ?></td>

                                        <td>
                                            <div class="d-flex gap-1">
                                                <a href="javascript:void(0);" id="feature-edit" data-id="<?php echo e($feature->id); ?>"
                                                   class="btn btn-sm btn-icon btn-outline-primary" title="Edit">
                                                    <i data-feather="edit-2"></i>
                                                </a>
                                                <a href="javascript:void(0);" onclick="confirmDelete(<?php echo e($feature->id); ?>)"
                                                   class="btn btn-sm btn-icon btn-outline-danger" title="Delete">
                                                    <i data-feather="trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!--/ features List Items -->

    </div>
    <!-- Delete features Modal -->
    <div class="modal fade modal-danger text-start" id="deletefeatureModal" tabindex="-1"
        aria-labelledby="deletefeaturesLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deletefeaturesLabel">تأكيد حذف</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
                </div>
                <div class="modal-body">
                    <p>هل انت متأكد من انك تريد حذف هذه الميزة ؟ لايمكن التراجع عن العملية</p>
                </div>
                <div class="modal-footer">
                    <form method="POST" id="deletefeatureForm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">اغلاق</button>
                        <button type="submit" class="btn btn-danger"> حذف</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade text-start" id="ceratModal" tabindex="-1"
        aria-labelledby="ceratModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <!-- سيتم تحميل المحتوى هنا -->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        function confirmDelete(featuresId) {
            const form = document.getElementById('deletefeatureForm');
            form.action ="<?php echo e(route('feature.destroy', ':id')); ?>".replace(':id', featuresId);
            const modal = new bootstrap.Modal(document.getElementById('deletefeatureModal'));
            modal.show();
        }
    </script>


    <script>
        $(document).ready(function() {
            $('.create_feature').on('click', function() {
                $.ajax({
                    url:  "<?php echo e(route('feature.create')); ?>",
                    method: 'GET',
                    success: function(response) {
                        // تعيين المحتوى إلى المودال
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        alert('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });
        });
    </script>
    <script>
        //featureForm submit
        $(document).on('submit', '.featureForm', function(e) {
            e.preventDefault();

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: "<?php echo e(route('feature.store')); ?>",
                method: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد

                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // // عرض الأخطاء لكل حقل
                        // if (errors.phone) {
                        //     $('.error-phone').text(errors.phone[0]);
                        // }
                        // if (errors.name) {
                        //     $('.error-name').text(errors.name[0]);
                        // }
                    }
                }
            });
        });

        //جلب بيانات تعديل الfeature
        $(document).on('click', '#feature-edit', function(e) {
            var featureId = $(this).data('id'); // Get ID

            $.ajax({
                url: "<?php echo e(route('feature.edit', ':id')); ?>".replace(':id', featureId),
                method: 'GET',
                success: function(response) {
                    // تعيين المحتوى إلى المودال
                    $('#ceratModal .modal-content').html(response.modalContent);
                    $('#ceratModal').modal('show');
                },
                error: function() {
                    toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                }
            });
        });


        //featureEditForm submit
        $(document).on('submit', '.featureEditForm', function(e) {
            e.preventDefault();
            var featureId = $(this).data('id'); // Get ID

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: "<?php echo e(route('feature.update', ':id')); ?>".replace(':id', featureId),
                method: 'PUT',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // // عرض الأخطاء لكل حقل
                        // if (errors.phone) {
                        //     $('.error-phone').text(errors.phone[0]);
                        // }
                        // if (errors.name) {
                        //     $('.error-name').text(errors.name[0]);
                        // }
                    }
                }
            });
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.dash_master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ivadev/public_html/resources/views/admin/feature/features.blade.php ENDPATH**/ ?>