<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Admin\FaqController;

use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\PlanController;
use App\Http\Controllers\Admin\WorkController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\ContentController;
use App\Http\Controllers\Admin\FeatureController;
use App\Http\Controllers\Admin\MessageController;
use App\Http\Controllers\Admin\OpinionController;
use App\Http\Controllers\Admin\ServiceController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\ContentsKController;
use App\Http\Controllers\Admin\KnowledgebaseController;
use App\Http\Controllers\FrontendController\HomeController;
use App\Http\Controllers\FrontendController\PageController;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use App\Http\Controllers\FrontendController\DomainPageController;
use App\Http\Controllers\FrontendController\HostingPageController;

Route::get('/clear-cache', function () {

   Artisan::call('cache:clear');
   Artisan::call('route:clear');
   Artisan::call('view:clear');

   return "Cache cleared successfully";
});

Route::group(
    ['prefix' => LaravelLocalization::setLocale(), 'middleware' => [\Mcamara\LaravelLocalization\Middleware\LocaleSessionRedirect::class,
    \Mcamara\LaravelLocalization\Middleware\LaravelLocalizationRedirectFilter::class,
    \Mcamara\LaravelLocalization\Middleware\LaravelLocalizationViewPath::class ]],
    function () {
    Route::get('/', [PageController::class, 'home'])->name('home');

    Route::get('/about', [PageController::class, 'about'])->name('about');
    Route::get('/Opinion', [PageController::class, 'Opinion'])->name('front.Opinion');
    Route::get('/faq', [PageController::class, 'faq'])->name('front.faq');
    Route::get('/services', [PageController::class, 'services'])->name('front.services');
    Route::get('/contact', [PageController::class, 'contact'])->name('front.contact');
    Route::post('/contact', [PageController::class, 'contact_store'])->name('front.store.contact');
    Route::get('/plans', [PageController::class, 'plans'])->name('front.plans');
    Route::get('/our_work', [PageController::class, 'our_work'])->name('front.our_work');
    Route::get('/blogs', [PageController::class, 'blogs'])->name('front.blogs');
    Route::get('/work/{id}', [PageController::class, 'work'])->name('front.work');
    Route::get('/blog/{id}', [PageController::class, 'blog'])->name('front.blog');
    Route::get('/knowledgebase/{id}', [PageController::class, 'knowledgebases'])->name('front.knowledgebases');
    Route::get('/form', [PageController::class, 'form'])->name('front.form');
    Route::post('/form', [PageController::class, 'store'])->name('front.store');
    Route::get('/Terms_of_Service', [PageController::class, 'Terms_of_Service'])->name('front.Terms_of_Service');
    Route::get('/Terms_of_Use', [PageController::class, 'Terms_of_Use'])->name('front.Terms_of_Use');
    Route::get('/Privacy', [PageController::class, 'Privacy'])->name('front.Privacy');

    }
);


Route::middleware('auth')->group(function () {
    Route::get('admin/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('admin/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('admin/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('admin/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');

    Route::get('admin/settings',[SettingController::class,'index'])->name('admin.settings');
    Route::put('update-site-setting',[SettingController::class,'updateSiteSetting'])->name('admin.update-general-setting');

    Route::get('admin/about-settings',[SettingController::class,'about_index'])->name('admin.about.settings');
    Route::put('update-about-setting',[SettingController::class,'updateAboutSetting'])->name('admin.update-about-setting');

    Route::get('admin/page-settings',[SettingController::class,'page_index'])->name('admin.page.settings');
    Route::put('update-page-setting',[SettingController::class,'updatePageSetting'])->name('admin.update-page-setting');

    Route::resource('admin/blog', BlogController::class);
    Route::resource('admin/knowledgebases', KnowledgebaseController::class);
    Route::put('knowledgebase-status/{id}', [KnowledgebaseController::class,'changeStatus'])->name('knowledgebase.status');
    Route::get('admin/knowledgebases/{id}/contents', [KnowledgebaseController::class, 'contents'])->name('knowledgebase.contents');
    Route::resource('admin/knowledgebaseContents', ContentsKController::class)->except(['create','show','index']);
    Route::resource('admin/faq', FaqController::class);
    Route::put('faq-status/{id}', [FaqController::class,'changeStatus'])->name('faq.status');
    Route::resource('admin/feature', FeatureController::class);
    Route::resource('admin/plan', PlanController::class);
    Route::put('admin/plan-status/{id}', [PlanController::class,'changeStatus'])->name('plan.status');
    Route::resource('admin/content', ContentController::class)->except('show');
    Route::resource('admin/service', ServiceController::class);
    Route::put('service-status/{id}', [ServiceController::class,'changeStatus'])->name('service.status');
    Route::resource('admin/work', WorkController::class);
    Route::resource('admin/opinion',OpinionController::class);

    Route::get('admin/orders', [OrderController::class, 'index'])->name('orders');
    Route::get('admin/order/{id}/edit', [OrderController::class, 'edit'])->name('order.edit');
    Route::PUT('/order/{id}/update', [OrderController::class, 'update'])->name('order.update');
    Route::delete('/order/{id}', [OrderController::class, 'destroy'])->name('order.destroy');

    Route::resource('admin/sliders', SliderController::class);


    Route::get('admin/messages', [MessageController::class, 'index'])->name('messages');
    Route::delete('/message/{id}', [MessageController::class, 'destroy'])->name('message.destroy');
});

require __DIR__.'/auth.php';
