@extends('layouts.dash_master')
@section('title')
    <title>{{ __('dash.Users') }}</title>
@endsection
@include('layouts.admin_sidebar')
@section('dash-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>{{ __('dash.Users') }}</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a
                            href="{{ route('admin.dashboard') }}">{{ __('dash.Dashboard') }}</a></div>
                    <div class="breadcrumb-item">{{ __('dash.Users') }}</div>
                </div>
            </div>

            <div class="section-body">
                <a href="#" class="btn btn-primary create_user"><i class="fas fa-plus"></i> {{ __('dash.Add New') }}</a>
                <div class="row mt-4">
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive table-invoice">
                                    <table class="table table-striped" id="dataTable">
                                        <thead>
                                            <tr>
                                                <th>{{ __('dash.SN') }}</th>
                                                <th>{{ __('dash.Name') }}</th>
                                                <th>{{ __('dash.Phone') }}</th>
                                                <th>{{ __('dash.Status') }}</th>
                                                <th>{{ __('dash.Action') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($users as $index => $user)
                                                <tr>
                                                    <td>{{ ++$index }}</td>
                                                    <td>{{ $user->name }}</td>

                                                    <td>{{ $user->phone }}
                                                    </td>
                                                    <td>
                                                        @if ($user->status == 'active')
                                                            <a href="javascript:;"
                                                                onclick="changeuserStatus({{ $user->id }})">
                                                                <input id="status_toggle" type="checkbox" checked
                                                                    data-toggle="toggle" data-on="{{ __('dash.Active') }}"
                                                                    data-off="{{ __('dash.Inactive') }}"
                                                                    data-onstyle="success" data-offstyle="danger">
                                                            </a>
                                                        @else
                                                            <a href="javascript:;"
                                                                onclick="changeuserStatus({{ $user->id }})">
                                                                <input id="status_toggle" type="checkbox"
                                                                    data-toggle="toggle" data-on="{{ __('dash.Active') }}"
                                                                    data-off="{{ __('dash.Inactive') }}"
                                                                    data-onstyle="success" data-offstyle="danger">
                                                            </a>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <a href="{{ route('admin.user.show', $user->id) }}" class="btn btn-info btn-sm">
                                                            <i class="fa-solid fa-eye"></i></a>
                                                        <a href="#" class="btn btn-primary btn-sm" id="user-edit" data-id="{{ $user->id }}"><i
                                                            class="fa fa-edit" aria-hidden="true" ></i></a>
                                                        <a href="javascript:;" data-toggle="modal"
                                                            data-target="#deleteModal" class="btn btn-danger btn-sm"
                                                            onclick="deleteData({{ $user->id }})"><i
                                                                class="fa fa-trash" aria-hidden="true"></i></a>

                                                    </td>

                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
 <!-- Modal -->
 <div class="modal fade" id="ceratModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <!-- سيتم تحميل المحتوى هنا -->
        </div>
    </div>
</div>

@endsection
@push('js')

<script>
    $(document).ready(function() {
        $('.create_user').on('click', function() {

            // جلب محتوى المودال باستخدام Ajax
            $.ajax({
                url: 'user/create',
                method: 'GET',
                success: function(response) {
                    // تعيين المحتوى إلى المودال
                    $('#ceratModal .modal-content').html(response.modalContent);
                    $('#ceratModal').modal('show');
                },
                error: function() {
                    alert('حدث خطأ أثناء جلب بيانات الطلب.');
                }
            });
        });
    });

</script>
<script>

        //userForm submit
        $(document).on('submit', '.userForm', function(e) {
            e.preventDefault();

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: '/user',
                method: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                localStorage.setItem('notification', JSON.stringify(response.notification));
                window.location.href = response.redirect_url; // احصل على الرابط من الرد

                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                     toastr.error('تاكد من البيانات');

                        // عرض الأخطاء لكل حقل
                        if (errors.phone) {
                            $('.error-phone').text(errors.phone[0]);
                        }
                        if (errors.name) {
                            $('.error-name').text(errors.name[0]);
                        }
                        if (errors.email) {
                            $('.error-email').text(errors.email[0]);
                        }
                        if (errors.password) {
                            $('.error-password').text(errors.password[0]);
                        }
                        if (errors.password_confirmation) {
                            $('.error-password_confirmation').text(errors.password_confirmation[0]);
                        }
                    }
                }
            });
        });

//جلب بيانات تعديل الuser
        $(document).on('click', '#user-edit', function(e) {
            var userId = $(this).data('id'); // Get ID

                $.ajax({
                    url: '/user/'+ userId + '/edit' ,
                    method: 'GET',
                    success: function(response) {
                        // تعيين المحتوى إلى المودال
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                       toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                    });
        });


        //userEditForm submit
        $(document).on('submit', '.userEditForm', function(e) {
            e.preventDefault();
            var userId = $(this).data('id'); // Get ID

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: '/user/'+ userId,
                method: 'PUT',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                     toastr.error('تاكد من البيانات');

                        // عرض الأخطاء لكل حقل
                        if (errors.phone) {
                            $('.error-phone').text(errors.phone[0]);
                        }
                        if (errors.name) {
                            $('.error-name').text(errors.name[0]);
                        }
                        if (errors.emdil) {
                            $('.error-emdil').text(errors.emdil[0]);
                        }
                        if (errors.password) {
                            $('.error-password').text(errors.password[0]);
                        }
                        if (errors.password_confirmation) {
                            $('.error-password_confirmation').text(errors.password_confirmation[0]);
                        }
                    }
                }
            });
        });

        function deleteData(id){
        $("#deleteForm").attr("action",'{{ url("user/") }}'+"/"+id)
        }
///change user Status
        function changeuserStatus(id){
        $.ajax({
            type:"put",
            data: { _token : '{{ csrf_token() }}' },
            url:"{{url('/user-status/')}}"+"/"+id,
            success:function(response){
                toastr.success(response)
            },
            error:function(err){


            }
        })
    }
</script>
@endpush
