@extends('layouts.dash_master')
@section('title')
    <title>{{ __('اعمالنا') }}</title>
@endsection

@section('dash-content')
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">السلايدرات</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">الرئيسية</a>
                            </li>
                            <li class="breadcrumb-item"> {{ __('السلايدر') }}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-header-right text-md-end col-md-3 col-12 d-md-block d-none">
            <div class="mb-1 breadcrumb-right">
                <a href="{{route('sliders.create')}}" class="btn btn-primary create_agent"><i class="fas fa-plus"></i> {{ __('اضف جديد') }}</a>
            </div>
        </div>
    </div>
    <div class="work-list-wrapper">
        <!-- work List Items -->
        <div class="row">
            @foreach ($works as $work)
            <div class="col-md-4 col-6">
                <div class="card">
                    <a href="">
                        <img class="card-img-top img-fluid" src="{{ asset('storage/files/' . ($work->image_ar ?? 'default.png')) }}"
                            alt="work Post pic">
                    </a>
                    <div class="card-body">
                        <h4 class="card-title">
                            <a href="" class="work-title-truncate text-body-heading">{{$work->title_ar}}</a>
                        </h4>
                        <div class="d-flex">
                            <div class="author-info">
                                <small class="text-muted">{{$work->created_at->format('d/m/Y')}}</small>
                            </div>
                        </div>

                        <hr>
                        <div class="d-flex justify-content-between align-items-center">
                                <button class="btn btn-flat-danger" onclick="confirmDelete({{ $work->id }})">
                                    حذف <i data-feather='trash'></i>
                                </button>
                            <a href="{{route('sliders.edit',$work->id)}}" class="fw-bold">تعديل <i data-feather='edit'></i></a>
                        </div>
                    </div>
                </div>
            </div>

            @endforeach
        </div>
        <!--/ work List Items -->

    </div>
  <!-- Delete work Modal -->
<div class="modal fade modal-danger text-start" id="deleteworkModal" tabindex="-1" aria-labelledby="deleteworkLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="deleteworkLabel">حذف سلايدر</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
            </div>
            <div class="modal-body">
                <p >هل انت متأكد من حذف هذا السلايدر؟ لايمكن التراجع عن هذه العملية</p>
            </div>
            <div class="modal-footer">
                <form method="POST" id="deleteworkForm">
                    @csrf
                    @method('DELETE')
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">اغلاق</button>
                    <button type="submit" class="btn btn-danger"> حذف</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@push('js')
<script>
    function confirmDelete(workId) {
        const form = document.getElementById('deleteworkForm');
        form.action =  "{{ route('sliders.destroy', ':id') }}".replace(':id', workId) ; // غيّر المسار حسب الراوت عندك
        const modal = new bootstrap.Modal(document.getElementById('deleteworkModal'));
        modal.show();
    }
    </script>
@endpush
