@extends('layouts.dash_master')
@section('title')
    <title>{{ __('dash.Sittings') }}</title>
@endsection

@section('dash-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-start mb-0">الاعدادات</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">الرئيسية</a>
                                    </li>
                                    <li class="breadcrumb-item active">الاعدادات
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section id="multiple-column-form">
            <div class="row">
                <div class="col-2">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">التعديلات الرئيسية</h4>
                        </div>
                        <div class="card-body">
                            <div class="nav-vertical">
                                <ul class="nav nav-tabs nav-left flex-column" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" id="baseVerticalLeft-tab1" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft1" href="#tabVerticalLeft1" role="tab"
                                            aria-selected="true"> تعديلات عامة</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab2" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft2" href="#tabVerticalLeft2" role="tab"
                                            aria-selected="false">القسم الاول</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab3" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft3" href="#tabVerticalLeft3" role="tab"
                                            aria-selected="false">القسم الثاني
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab4" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft4" href="#tabVerticalLeft4" role="tab"
                                            aria-selected="true">القسم الثالث</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab5" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft5" href="#tabVerticalLeft5" role="tab"
                                            aria-selected="false">القسم الرابع</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab6" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft6" href="#tabVerticalLeft6" role="tab"
                                            aria-selected="false">القسم الخامس
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab7" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft7" href="#tabVerticalLeft7" role="tab"
                                            aria-selected="true"> القسم السادس</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab8" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft8" href="#tabVerticalLeft8" role="tab"
                                            aria-selected="false">القسم السابع</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab9" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft9" href="#tabVerticalLeft9" role="tab"
                                            aria-selected="false">القسم الثامن
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab10" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft10" href="#tabVerticalLeft10" role="tab"
                                            aria-selected="true">القسم التاسع</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab11" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft11" href="#tabVerticalLeft11" role="tab"
                                            aria-selected="false">القسم العاشر</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab12" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft12" href="#tabVerticalLeft12" role="tab"
                                            aria-selected="false">القسم الحادي عشر
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-10">
                    <div class="tab-content">
                        <div class="tab-pane active" id="tabVerticalLeft1" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab1">
                            <p>
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic-tab" data-bs-toggle="tab"
                                                            href="#arabic" aria-controls="arabic" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english-tab" data-bs-toggle="tab"
                                                            href="#english" aria-controls="english" role="tab"
                                                            aria-selected="false"> English</a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic"
                                                        aria-labelledby="arabic-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('اسم الموقع') }}" name="site_name"
                                                            value="{{ old('site_name', $setting->site_name ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('نص الفوتر') }}" name="footer"
                                                            value="{{ old('footer', $setting->footer ?? '') }}"
                                                            maxLength="250" col="12" />
                                                        <x-input-field type="text" label="{{ __('العنوان') }}"
                                                            name="address"
                                                            value="{{ old('address', $setting->address ?? '') }}"
                                                            maxLength="250" />

                                                    </div>
                                                    <div class="tab-pane" id="english" aria-labelledby="english-tab"
                                                        role="tabpanel">

                                                        <x-input-field label="{{ __('en اسم الموقع') }}"
                                                            name="site_name_en"
                                                            value="{{ old('site_name_en', $setting->site_name_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __(' en نص الفوتر') }}" name="footer_en"
                                                            value="{{ old('footer_en', $setting->footer_en ?? '') }}"
                                                            maxLength="250" col="12" />
                                                        <x-input-field type="text" label="{{ __('en العنوان') }}"
                                                                name="address_en"
                                                                value="{{ old('address_en', $setting->address_en ?? '') }}"
                                                                maxLength="250" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card">
                                            <div class="card-body">
                                                <x-input-field type="email" label="{{ __('Email') }}" name="email"
                                                    value="{{ old('email', $setting->email ?? '') }}" maxLength="250" />

                                                <x-input-field type="number" label="{{ __('رقم الهاتف') }}"
                                                    name="phone" value="{{ old('phone', $setting->phone ?? '') }}"
                                                    maxLength="250" />

                                                <x-input-field type="link" label="{{ __('Whatsapp') }}"
                                                    name="whatsapp"
                                                    value="{{ old('whatsapp', $setting->whatsapp ?? '') }}"
                                                    maxLength="250" />

                                                <x-input-field type="link" label="{{ __('facebook') }}"
                                                    name="facebook"
                                                    value="{{ old('facebook', $setting->facebook ?? '') }}"
                                                    maxLength="250" />

                                                <x-input-field type="link" label="{{ __('twitter') }}" name="twitter"
                                                    value="{{ old('twitter', $setting->twitter ?? '') }}"
                                                    maxLength="250" />

                                                <x-input-field type="link" label="{{ __('instagram') }}"
                                                    name="instagram"
                                                    value="{{ old('instagram', $setting->instagram ?? '') }}"
                                                    maxLength="250" />

                                                <x-input-field type="link" label="{{ __('linkedin') }}"
                                                    name="linkedin"
                                                    value="{{ old('linkedin', $setting->linkedin ?? '') }}"
                                                    maxLength="250" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="row">
                                            <div class="card">
                                                <div class="card-header">
                                                    <h4 class="card-title">صور</h4>
                                                </div>
                                                <div class="card-body">
                                                    {{-- //logo --}}
                                                    <div class="col-md-12 m-2">
                                                        <div class="form-group">
                                                            <input type='file' onchange="loadFile_image(logo)"
                                                                name="logo" id="logo"
                                                                class="@error('logo') is-invalid @enderror"
                                                                style="display:none;" />
                                                            <button id="output_logo" type="button"
                                                                onclick="document.getElementById('logo').click();"
                                                                style="width: 190px;
                                                                                        height: 120px;
                                                                                        border-radius: 0.357rem !important;
                                                                                        background-color: #cecbcb;
                                                                                        background-image: url({{ asset('storage/files/' . ($setting->logo ?? 'default.png')) }});
                                                                                        background-repeat: no-repeat;
                                                                                        background-size: cover;
                                                                                        background-position: center;
                                                                                        " />
                                                        </div>
                                                        <label for="username">{{ __('الشعار') }}</label>
                                                    </div>
                                                    <script>
                                                        var loadFile_image = function(image) {
                                                            var image = document.getElementById('output_logo');
                                                            var src = URL.createObjectURL(event.target.files[0]);
                                                            image.style.backgroundImage = 'url(' + src + ')';
                                                        };
                                                    </script>

                                                    {{-- //logo_secondary --}}
                                                    <div class="col-md-12 m-2">
                                                        <div class="form-group">
                                                            <input type='file' onchange="loadFile_image(logo_secondary)"
                                                                name="logo_secondary" id="logo_secondary"
                                                                class="@error('logo_secondary') is-invalid @enderror"
                                                                style="display:none;" />
                                                            <button id="output_logo_secondary" type="button"
                                                                onclick="document.getElementById('logo_secondary').click();"
                                                                style="width: 190px;
                                                                                        height: 120px;
                                                                                        border-radius: 0.357rem !important;
                                                                                        background-color: #cecbcb;
                                                                                        background-image: url({{ asset('storage/files/' . ($setting->logo_secondary ?? 'default.png')) }});
                                                                                        background-repeat: no-repeat;
                                                                                        background-size: cover;
                                                                                        background-position: center;
                                                                                        " />
                                                        </div>
                                                        <label for="username">الشعار ملون</label>
                                                    </div>
                                                    <script>
                                                        var loadFile_image = function(image) {
                                                            var image = document.getElementById('output_logo_secondary');
                                                            var src = URL.createObjectURL(event.target.files[0]);
                                                            image.style.backgroundImage = 'url(' + src + ')';
                                                        };
                                                    </script>
                                                    {{-- //favicon --}}
                                                    <div class="col-md-12 m-2">
                                                        <div class="form-group">
                                                            <input type='file' onchange="loadFile_image2(favicon)"
                                                                name="favicon" id="favicon"
                                                                class="@error('favicon') is-invalid @enderror"
                                                                style="display:none;" />
                                                            <button id="output_favicon" type="button"
                                                                onclick="document.getElementById('favicon').click();"
                                                                style="
                                                                                            width: 90px;
                                                                                            height: 90px;
                                                                                            border-radius: 50%;
                                                                                            background-color: #cecbcb;
                                                                                            background-image: url({{ asset('storage/files/' . ($setting->favicon ?? 'default.png')) }});
                                                                                            background-repeat: no-repeat;
                                                                                            background-size: cover;
                                                                                            background-position: center;
                                                                                            " />
                                                        </div>
                                                        <label for="username">{{ __('Favicon ') }}</label>
                                                    </div>
                                                    <script>
                                                        var loadFile_image2 = function(image2) {
                                                            var image2 = document.getElementById('output_favicon');
                                                            var src2 = URL.createObjectURL(event.target.files[0]);
                                                            image2.style.backgroundImage = 'url(' + src2 + ')';
                                                        };
                                                    </script>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                            </p>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft2" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab2">
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic2-tab" data-bs-toggle="tab"
                                                            href="#arabic2" aria-controls="arabic2" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english2-tab" data-bs-toggle="tab"
                                                            href="#english2" aria-controls="english2" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic2"
                                                        aria-labelledby="arabic2-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('عنوان القسم') }}"
                                                            name="section1_title"
                                                            value="{{ old('section1_title', $setting->section1_title ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <div class="col-12 mb-1">
                                                            <label for="section1_content">
                                                                {{ __('محتوى القسم') }}</label>
                                                            <textarea name="section1_content" rows="10" id="section1_content" class="form-control">{!! $setting->section1_content !!}</textarea>
                                                        </div>

                                                    </div>
                                                    <div class="tab-pane" id="english2" aria-labelledby="english2-tab"
                                                        role="tabpanel">

                                                        <x-input-field label="{{ __('en عنوان القسم') }}"
                                                            name="section1_title_en"
                                                            value="{{ old('section1_title_en', $setting->section1_title_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <div class="col-12 mb-1">
                                                            <label for="section1_content_en">
                                                                {{ __('محتوى القسم en') }}</label>
                                                            <textarea name="section1_content_en" rows="10" id="section1_content_en" class="form-control">{!! $setting->section1_content_en !!}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="row">
                                            <div class="card">
                                                <div class="card-body">
                                                    {{-- //section1_image --}}
                                                    <div class="col-md-12 m-2">
                                                        <div class="form-group">
                                                            <input type='file'
                                                                onchange="loadFile_image3(section1_image)"
                                                                name="section1_image" id="section1_image"
                                                                class="@error('section1_image') is-invalid @enderror"
                                                                style="display:none;" />
                                                            <button id="output_section1_image" type="button"
                                                                onclick="document.getElementById('section1_image').click();"
                                                                style="width: 190px;
                                                                                    height: 120px;
                                                                                    border-radius: 0.357rem !important;
                                                                                    background-color: #cecbcb;
                                                                                    background-image: url({{ asset('storage/files/' . ($setting->section1_image ?? 'default.png')) }});
                                                                                    background-repeat: no-repeat;
                                                                                    background-size: cover;
                                                                                    background-position: center;
                                                                                    " />
                                                        </div>
                                                        <label for="username">{{ __('صورة السلايد') }}</label>
                                                    </div>
                                                    <script>
                                                        var loadFile_image3 = function(image3) {
                                                            var image3 = document.getElementById('output_section1_image');
                                                            var src3 = URL.createObjectURL(event.target.files[0]);
                                                            image3.style.backgroundImage = 'url(' + src3 + ')';
                                                        };
                                                    </script>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft3" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab3">
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic3-tab" data-bs-toggle="tab"
                                                            href="#arabic3" aria-controls="arabic3" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english3-tab" data-bs-toggle="tab"
                                                            href="#english3" aria-controls="english3" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic3"
                                                        aria-labelledby="arabic3-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('عنوان القسم') }}"
                                                            name="section2_title"
                                                            value="{{ old('section2_title', $setting->section2_title ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('عنوان فرعي للقسم') }}"
                                                            name="section2_subtitle"
                                                            value="{{ old('section2_subtitle', $setting->section2_subtitle ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <div class="col-12 mb-1">
                                                            <label for="section2_content">
                                                                {{ __('محتوى القسم') }}</label>
                                                            <textarea name="section2_content" rows="10" id="section2_content" class="form-control">{!! $setting->section2_content !!}</textarea>
                                                        </div>

                                                    </div>
                                                    <div class="tab-pane" id="english3" aria-labelledby="english3-tab"
                                                        role="tabpanel">

                                                        <x-input-field label="{{ __('en عنوان القسم') }}"
                                                            name="section2_title_en"
                                                            value="{{ old('section2_title_en', $setting->section2_title_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('en عنوان فرعي للقسم') }}"
                                                            name="section2_subtitle_en"
                                                            value="{{ old('section2_subtitle_en', $setting->section2_subtitle_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <div class="col-12 mb-1">
                                                            <label for="section2_content_en">
                                                                {{ __('en محتوى القسم') }}</label>
                                                            <textarea name="section2_content_en" rows="10" id="section2_content_en" class="form-control">{!! $setting->section2_content_en !!}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="row">
                                            <div class="card">
                                                <div class="card-body">
                                                    {{-- //section2_image --}}
                                                    <div class="col-md-12 m-2">
                                                        <div class="form-group">
                                                            <input type='file'
                                                                onchange="loadFile_image4(section2_image1)"
                                                                name="section2_image1" id="section2_image1"
                                                                class="@error('section2_image1') is-invalid @enderror"
                                                                style="display:none;" />
                                                            <button id="output_section2_image1" type="button"
                                                                onclick="document.getElementById('section2_image1').click();"
                                                                style="width: 111px;
                                                                                height: 160px;
                                                                                border-radius: 0.357rem !important;
                                                                                background-color: #cecbcb;
                                                                                background-image: url({{ asset('storage/files/' . ($setting->section2_image1 ?? 'default.png')) }});
                                                                                background-repeat: no-repeat;
                                                                                background-size: cover;
                                                                                background-position: center;
                                                                                " />
                                                        </div>
                                                        <label for="username">{{ __('صورة  1') }}</label>
                                                    </div>
                                                    <script>
                                                        var loadFile_image4 = function(image4) {
                                                            var image4 = document.getElementById('output_section2_image1');
                                                            var src4 = URL.createObjectURL(event.target.files[0]);
                                                            image4.style.backgroundImage = 'url(' + src4 + ')';
                                                        };
                                                    </script>

                                                    <div class="col-md-12 m-2">
                                                        <div class="form-group">
                                                            <input type='file'
                                                                onchange="loadFile_image5(section2_image2)"
                                                                name="section2_image2" id="section2_image2"
                                                                class="@error('section2_image2') is-invalid @enderror"
                                                                style="display:none;" />
                                                            <button id="output_section2_image2" type="button"
                                                                onclick="document.getElementById('section2_image2').click();"
                                                                style="width: 111px;
                                                                        height: 150px;
                                                                        border-radius: 0.357rem !important;
                                                                        background-color: #cecbcb;
                                                                        background-image: url({{ asset('storage/files/' . ($setting->section2_image2 ?? 'default.png')) }});
                                                                        background-repeat: no-repeat;
                                                                        background-size: cover;
                                                                        background-position: center;
                                                                        " />
                                                        </div>
                                                        <label for="username">{{ __(' صورة 2') }}</label>
                                                    </div>
                                                    <script>
                                                        var loadFile_image5 = function(image5) {
                                                            var image5 = document.getElementById('output_section2_image2');
                                                            var src5 = URL.createObjectURL(event.target.files[0]);
                                                            image5.style.backgroundImage = 'url(' + src5 + ')';
                                                        };
                                                    </script>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft4" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab4">
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic4-tab" data-bs-toggle="tab"
                                                            href="#arabic4" aria-controls="arabic4" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english4-tab" data-bs-toggle="tab"
                                                            href="#english4" aria-controls="english4" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic4"
                                                        aria-labelledby="arabic4-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('عنوان القسم') }}"
                                                            name="section3_title"
                                                            value="{{ old('section3_title', $setting->section3_title ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <div class="col-12 mb-1">
                                                            <label for="section3_content">
                                                                {{ __('محتوى القسم') }}</label>
                                                            <textarea name="section3_content" rows="10" id="section3_content" class="form-control">{!! $setting->section3_content !!}</textarea>
                                                        </div>

                                                    </div>
                                                    <div class="tab-pane" id="english4" aria-labelledby="english4-tab"
                                                        role="tabpanel">

                                                        <x-input-field label="{{ __('en عنوان القسم') }}"
                                                            name="section3_title_en"
                                                            value="{{ old('section3_title_en', $setting->section3_title_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <div class="col-12 mb-1">
                                                            <label for="section3_content_en">
                                                                {{ __('en محتوى القسم') }}</label>
                                                            <textarea name="section3_content_en" rows="10" id="section3_content_en" class="form-control">{!! $setting->section3_content_en !!}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="row">
                                            <div class="card">
                                                <div class="card-body">
                                                    {{-- //section2_image --}}
                                                    <div class="col-md-12 m-2">
                                                        <div class="form-group">
                                                            <input type='file'
                                                                onchange="loadFile_image6(section3_image)"
                                                                name="section3_image" id="section3_image"
                                                                class="@error('section3_image') is-invalid @enderror"
                                                                style="display:none;" />
                                                            <button id="output_section3_image" type="button"
                                                                onclick="document.getElementById('section3_image').click();"
                                                                style="width: 111px;
                                                                                height: 160px;
                                                                                border-radius: 0.357rem !important;
                                                                                background-color: #cecbcb;
                                                                                background-image: url({{ asset('storage/files/' . ($setting->section3_image ?? 'default.png')) }});
                                                                                background-repeat: no-repeat;
                                                                                background-size: cover;
                                                                                background-position: center;
                                                                                " />
                                                        </div>
                                                        <label for="username">{{ __('صورة  1') }}</label>
                                                    </div>
                                                    <script>
                                                        var loadFile_image6 = function(image6) {
                                                            var image6 = document.getElementById('output_section3_image');
                                                            var src6 = URL.createObjectURL(event.target.files[0]);
                                                            image6.style.backgroundImage = 'url(' + src6 + ')';
                                                        };
                                                    </script>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft5" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab5">
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic5-tab" data-bs-toggle="tab"
                                                            href="#arabic5" aria-controls="arabic5" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english5-tab" data-bs-toggle="tab"
                                                            href="#english5" aria-controls="english5" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic5"
                                                        aria-labelledby="arabic5-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('عنوان القسم') }}"
                                                            name="section4_title"
                                                            value="{{ old('section4_title', $setting->section4_title ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <div class="col-12 mb-1">
                                                            <label for="section4_content">
                                                                {{ __('محتوى القسم') }}</label>
                                                            <textarea name="section4_content" rows="10" id="section4_content" class="form-control">{!! $setting->section4_content !!}</textarea>
                                                        </div>

                                                    </div>
                                                    <div class="tab-pane" id="english5" aria-labelledby="english5-tab"
                                                        role="tabpanel">

                                                        <x-input-field label="{{ __('en عنوان القسم') }}"
                                                            name="section4_title_en"
                                                            value="{{ old('section4_title_en', $setting->section4_title_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <div class="col-12 mb-1">
                                                            <label for="section4_content_en">
                                                                {{ __('en محتوى القسم') }}</label>
                                                            <textarea name="section4_content_en" rows="10" id="section4_content_en" class="form-control">{!! $setting->section4_content_en !!}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="row">
                                            <div class="card">
                                                <div class="card-body">

                                                    <div class="col-md-12 m-2">
                                                        <div class="form-group">
                                                            <input type='file'
                                                                onchange="loadFile_image7(section4_image1)"
                                                                name="section4_image1" id="section4_image1"
                                                                class="@error('section4_image1') is-invalid @enderror"
                                                                style="display:none;" />
                                                            <button id="output_section4_image1" type="button"
                                                                onclick="document.getElementById('section4_image1').click();"
                                                                style="width: 111px;
                                                                                height: 160px;
                                                                                border-radius: 0.357rem !important;
                                                                                background-color: #cecbcb;
                                                                                background-image: url({{ asset('storage/files/' . ($setting->section4_image1 ?? 'default.png')) }});
                                                                                background-repeat: no-repeat;
                                                                                background-size: cover;
                                                                                background-position: center;
                                                                                " />
                                                        </div>
                                                        <label for="username">{{ __('صورة  1') }}</label>
                                                    </div>
                                                    <script>
                                                        var loadFile_image7 = function(image7) {
                                                            var image7 = document.getElementById('output_section4_image1');
                                                            var src7 = URL.createObjectURL(event.target.files[0]);
                                                            image7.style.backgroundImage = 'url(' + src7 + ')';
                                                        };
                                                    </script>
                                                    <div class="col-md-12 m-2">
                                                        <div class="form-group">
                                                            <input type='file'
                                                                onchange="loadFile_image8(section4_image2)"
                                                                name="section4_image2" id="section4_image2"
                                                                class="@error('section4_image2') is-invalid @enderror"
                                                                style="display:none;" />
                                                            <button id="output_section4_image2" type="button"
                                                                onclick="document.getElementById('section4_image2').click();"
                                                                style="width: 111px;
                                                                                height: 160px;
                                                                                border-radius: 0.357rem !important;
                                                                                background-color: #cecbcb;
                                                                                background-image: url({{ asset('storage/files/' . ($setting->section4_image2 ?? 'default.png')) }});
                                                                                background-repeat: no-repeat;
                                                                                background-size: cover;
                                                                                background-position: center;
                                                                                " />
                                                        </div>
                                                        <label for="username">{{ __('صورة  2') }}</label>
                                                    </div>
                                                    <script>
                                                        var loadFile_image8 = function(image8) {
                                                            var image8 = document.getElementById('output_section4_image2');
                                                            var src8 = URL.createObjectURL(event.target.files[0]);
                                                            image8.style.backgroundImage = 'url(' + src8 + ')';
                                                        };
                                                    </script>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft6" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab6">
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic6-tab" data-bs-toggle="tab"
                                                            href="#arabic6" aria-controls="arabic6" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english6-tab" data-bs-toggle="tab"
                                                            href="#english6" aria-controls="english6" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic6"
                                                        aria-labelledby="arabic6-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('5 عنوان القسم') }}"
                                                            name="section5_title"
                                                            value="{{ old('section5_title', $setting->section5_title ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('عنوان فرعي للقسم') }}"
                                                            name="section5_subtitle"
                                                            value="{{ old('section5_subtitle', $setting->section5_subtitle ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                    <div class="tab-pane" id="english6" aria-labelledby="english6-tab"
                                                        role="tabpanel">

                                                        <x-input-field label="{{ __('en 5 عنوان القسم') }}"
                                                            name="section5_title_en"
                                                            value="{{ old('section5_title_en', $setting->section5_title_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('en عنوان فرعي للقسم') }}"
                                                            name="section5_subtitle_en"
                                                            value="{{ old('section5_subtitle_en', $setting->section5_subtitle_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft7" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab7">
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic7-tab" data-bs-toggle="tab"
                                                            href="#arabic7" aria-controls="arabic7" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english7-tab" data-bs-toggle="tab"
                                                            href="#english7" aria-controls="english7" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic7"
                                                        aria-labelledby="arabic7-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('6 عنوان القسم') }}"
                                                            name="section6_title"
                                                            value="{{ old('section6_title', $setting->section6_title ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('عنوان فرعي للقسم') }}"
                                                            name="section6_subtitle"
                                                            value="{{ old('section6_subtitle', $setting->section6_subtitle ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                    <div class="tab-pane" id="english7" aria-labelledby="english7-tab"
                                                        role="tabpanel">

                                                        <x-input-field label="{{ __('en 6 عنوان القسم') }}"
                                                            name="section6_title_en"
                                                            value="{{ old('section6_title_en', $setting->section6_title_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('en عنوان فرعي للقسم') }}"
                                                            name="section6_subtitle_en"
                                                            value="{{ old('section6_subtitle_en', $setting->section6_subtitle_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft8" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab8">
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic8-tab" data-bs-toggle="tab"
                                                            href="#arabic8" aria-controls="arabic8" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english8-tab" data-bs-toggle="tab"
                                                            href="#english8" aria-controls="english8" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic8"
                                                        aria-labelledby="arabic8-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('7 عنوان القسم') }}"
                                                            name="section7_title"
                                                            value="{{ old('section7_title', $setting->section7_title ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('عنوان فرعي للقسم') }}"
                                                            name="section7_subtitle"
                                                            value="{{ old('section7_subtitle', $setting->section7_subtitle ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                    <div class="tab-pane" id="english8" aria-labelledby="english8-tab"
                                                        role="tabpanel">

                                                        <x-input-field label="{{ __('en 7 عنوان القسم') }}"
                                                            name="section7_title_en"
                                                            value="{{ old('section7_title_en', $setting->section7_title_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('en عنوان فرعي للقسم') }}"
                                                            name="section7_subtitle_en"
                                                            value="{{ old('section7_subtitle_en', $setting->section7_subtitle_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft9" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab9">
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic9-tab" data-bs-toggle="tab"
                                                            href="#arabic9" aria-controls="arabic9" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english9-tab" data-bs-toggle="tab"
                                                            href="#english9" aria-controls="english9" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic9"
                                                        aria-labelledby="arabic9-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('8 عنوان القسم') }}"
                                                            name="section8_title"
                                                            value="{{ old('section8_title', $setting->section8_title ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('عنوان فرعي للقسم') }}"
                                                            name="section8_subtitle"
                                                            value="{{ old('section8_subtitle', $setting->section8_subtitle ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                    <div class="tab-pane" id="english9" aria-labelledby="english9-tab"
                                                        role="tabpanel">

                                                        <x-input-field label="{{ __('en 8 عنوان القسم') }}"
                                                            name="section8_title_en"
                                                            value="{{ old('section8_title_en', $setting->section8_title_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('en عنوان فرعي للقسم') }}"
                                                            name="section8_subtitle_en"
                                                            value="{{ old('section8_subtitle_en', $setting->section8_subtitle_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft10" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab10">
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic10-tab" data-bs-toggle="tab"
                                                            href="#arabic10" aria-controls="arabic10" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english10-tab" data-bs-toggle="tab"
                                                            href="#english10" aria-controls="english10" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic10"
                                                        aria-labelledby="arabic10-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('9 عنوان القسم') }}"
                                                            name="section9_title"
                                                            value="{{ old('section9_title', $setting->section9_title ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('عنوان فرعي للقسم') }}"
                                                            name="section9_subtitle"
                                                            value="{{ old('section9_subtitle', $setting->section9_subtitle ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                    <div class="tab-pane" id="english10" aria-labelledby="english10-tab"
                                                        role="tabpanel">

                                                        <x-input-field label="{{ __('en 9 عنوان القسم') }}"
                                                            name="section9_title_en"
                                                            value="{{ old('section9_title_en', $setting->section9_title_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('en عنوان فرعي للقسم') }}"
                                                            name="section9_subtitle_en"
                                                            value="{{ old('section9_subtitle_en', $setting->section9_subtitle_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft11" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab11">
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic11-tab" data-bs-toggle="tab"
                                                            href="#arabic11" aria-controls="arabic11" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english11-tab" data-bs-toggle="tab"
                                                            href="#english11" aria-controls="english6" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic11"
                                                        aria-labelledby="arabic11-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('10 عنوان القسم') }}"
                                                            name="section10_title"
                                                            value="{{ old('section10_title', $setting->section10_title ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('عنوان فرعي للقسم') }}"
                                                            name="section10_subtitle"
                                                            value="{{ old('section10_subtitle', $setting->section10_subtitle ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                    <div class="tab-pane" id="english11" aria-labelledby="english11-tab"
                                                        role="tabpanel">

                                                        <x-input-field label="{{ __('en 10 عنوان القسم') }}"
                                                            name="section10_title_en"
                                                            value="{{ old('section10_title_en', $setting->section10_title_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('en عنوان فرعي للقسم') }}"
                                                            name="section10_subtitle_en"
                                                            value="{{ old('section10_subtitle_en', $setting->section10_subtitle_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft12" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab12">
                            <form action="{{ route('admin.update-general-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic12-tab" data-bs-toggle="tab"
                                                            href="#arabic12" aria-controls="arabic12" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english12-tab" data-bs-toggle="tab"
                                                            href="#english12" aria-controls="english12" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic12"
                                                        aria-labelledby="arabic12-tab" role="tabpanel">
                                                        <x-input-field label="{{ __('11 عنوان القسم') }}"
                                                            name="section11_title"
                                                            value="{{ old('section11_title', $setting->section11_title ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('عنوان فرعي للقسم') }}"
                                                            name="section11_subtitle"
                                                            value="{{ old('section11_subtitle', $setting->section11_subtitle ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                    <div class="tab-pane" id="english12"
                                                        aria-labelledby="english12-tab" role="tabpanel">

                                                        <x-input-field label="{{ __('en 11 عنوان القسم') }}"
                                                            name="section11_title_en"
                                                            value="{{ old('section11_title_en', $setting->section11_title_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                        <x-input-field label="{{ __('en عنوان فرعي للقسم') }}"
                                                            name="section11_subtitle_en"
                                                            value="{{ old('section11_subtitle_en', $setting->section11_subtitle_en ?? '') }}"
                                                            maxLength="250" col="12" />

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>

                    </div>
                </div>
            </div>

        </section>
    </div>
@endsection
@push('js')
    <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
    <script>
        ClassicEditor
            .create(document.querySelector('#section1_content'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });
        ClassicEditor
            .create(document.querySelector('#section1_content_en'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });

        ClassicEditor
            .create(document.querySelector('#section2_content'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });

        ClassicEditor
            .create(document.querySelector('#section2_content_en'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });

        ClassicEditor
            .create(document.querySelector('#section3_content'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });

        ClassicEditor
            .create(document.querySelector('#section3_content_en'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });

        ClassicEditor
            .create(document.querySelector('#section4_content'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });
        ClassicEditor
            .create(document.querySelector('#section4_content_en'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });
    </script>
@endpush
