@extends('layouts.dash_master')
@section('title')
    <title>{{ __('dash.Ditails Agent') }}</title>
@endsection
@include('layouts.admin_sidebar')
@section('dash-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>{{ __('dash.Ditails Agent') }}</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a
                            href="{{ route('admin.agent.index') }}">{{ __('dash.Agents') }}</a></div>
                    <div class="breadcrumb-item">{{ __('dash.Ditails Agent') }}</div>
                </div>
            </div>
            <div class="row">
            <x-card title="{{ __('dash.Name') }}" color="success"
                      icon="fas fa-solid fa-user" value="{{$agent->name}}" />
            <x-card title="{{ __('dash.phone') }}" color="info"
                        icon="fas fa-solid fa-phone" value="{{$agent->phone}}" />
            <x-card title="{{ __('dash.Number of contact') }}" color="primary"
                          icon="fas fa-solid fa-users" value="{{$agent->contacts->count()}}" />
           <x-card title="{{ __('dash.Company') }}" color="info"
                          icon="fas fa-solid fa-building" value="{{ $agent->company->name ?? 'غير منتمي لشركة' }}" />
            </div>
            <div class="section-body">
                <a href="#" class="btn btn-primary create_contact"><i class="fas fa-plus"></i> {{ __('dash.Add New') }}</a>
                <div class="row mt-4">
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive table-invoice">
                                    <table class="table table-striped" id="dataTable">
                                        <thead>
                                            <tr>
                                                <th>{{ __('dash.SN') }}</th>
                                                <th>{{ __('dash.Name') }}</th>
                                                <th>{{ __('dash.Phone') }}</th>
                                                <th>{{ __('dash.Agent') }}</th>
                                                <th>{{ __('dash.Action') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($agent->contacts as $index => $contact)
                                                <tr>
                                                    <td>{{ ++$index }}</td>
                                                    <td>{{ $contact->name }}</td>

                                                    <td> <a href="tel:{{$contact->phone }}"> {{$contact->phone }} </a>
                                                    </td>
                                                    <td>{{ $contact->agent->name }}
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-primary btn-sm" id="contact-edit" data-id="{{ $contact->id }}"><i
                                                            class="fa fa-edit" aria-hidden="true" ></i></a>
                                                        <a href="javascript:;" data-toggle="modal"
                                                            data-target="#deleteModal" class="btn btn-danger btn-sm"
                                                            onclick="deleteData({{ $contact->id }})"><i
                                                                class="fa fa-trash" aria-hidden="true"></i></a>

                                                    </td>

                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
 <!-- Modal -->
 <div class="modal fade" id="ceratModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <!-- سيتم تحميل المحتوى هنا -->
        </div>
    </div>
</div>

@endsection
@push('js')

<script>
    $(document).ready(function() {
        $('.create_contact').on('click', function() {

            // جلب محتوى المودال باستخدام Ajax
            $.ajax({
                url: '{{ route("admin.contact.create" ) }}',
                method: 'GET',
                success: function(response) {
                    // تعيين المحتوى إلى المودال
                    $('#ceratModal .modal-content').html(response.modalContent);
                    $('#ceratModal').modal('show');
                },
                error: function() {
                    alert('حدث خطأ أثناء جلب بيانات الطلب.');
                }
            });
        });
    });

</script>
<script>

        //contactForm submit
        $(document).on('submit', '.contactForm', function(e) {
            e.preventDefault();

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: '{{ route("admin.contact.store" ) }}',
                method: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                localStorage.setItem('notification', JSON.stringify(response.notification));
                window.location.href = response.redirect_url; // احصل على الرابط من الرد

                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                     toastr.error('تاكد من البيانات');

                        // عرض الأخطاء لكل حقل
                        if (errors.phone) {
                            $('.error-phone').text(errors.phone[0]);
                        }
                        if (errors.name) {
                            $('.error-name').text(errors.name[0]);
                        }
                        if (errors.email) {
                            $('.error-email').text(errors.email[0]);
                        }
                        if (errors.notes) {
                            $('.error-notes').text(errors.notes[0]);
                        }
                    }
                }
            });
        });

//جلب بيانات تعديل الcontact
        $(document).on('click', '#contact-edit', function(e) {
            var contactId = $(this).data('id'); // Get ID

                $.ajax({
                    url: '{{ route("admin.contact.edit", ":contactId") }}'.replace(':contactId', contactId),
                    method: 'GET',
                    success: function(response) {
                        // تعيين المحتوى إلى المودال
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                       toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                    });
        });


        //contactEditForm submit
        $(document).on('submit', '.contactEditForm', function(e) {
            e.preventDefault();
            var contactId = $(this).data('id'); // Get ID

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: '{{ route("admin.contact.update", ":contactId") }}'.replace(':contactId', contactId),
                method: 'PUT',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                     toastr.error('تاكد من البيانات');

                        // عرض الأخطاء لكل حقل
                        if (errors.phone) {
                            $('.error-phone').text(errors.phone[0]);
                        }
                        if (errors.name) {
                            $('.error-name').text(errors.name[0]);
                        }
                        if (errors.email) {
                            $('.error-email').text(errors.email[0]);
                        }
                        if (errors.notes) {
                            $('.error-notes').text(errors.notes[0]);
                        }
                    }
                }
            });
        });

        function deleteData(id){
        $("#deleteForm").attr("action",'{{ url("contact/") }}'+"/"+id)
        }
</script>
@endpush
