@extends('Frontend.Layouts.app')
@section('title', 'Knowledgebase')
@section('content')
    <!-- HEADER AREA -->
        @include('Frontend.Includes.Headers.headerOne')
    <!-- HEADER AREA END -->

    <!-- shared hosting banner -->
    <div class="rts-hosting-banner rts-hosting-banner-bg banner-default-height">
        <div class="container">
            <div class="row justify-content-sm-center">
                <div class="banner-area">
                    <div class="rts-hosting-banner rts-hosting-banner__content w-550">
                        <span class="starting__price" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Knowledgebase</span>
                        <h1 class="banner-title" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                            knowledgebase List
                        </h1>
                        <p class="slogan" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800"> We collaborate with the providers of best-of-breed technologies, services, and other streams.</p>
                        <div class="hosting-action">
                            <a href="{{route('pricing')}}" class="btn__two secondary__bg secondary__color">Start Now <i class="fa-regular fa-long-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="rts-hosting-banner__image mt-md-5">
                        <img src="{{asset ('assets/images/banner/knowledgebase.png') }}" alt="">
                        <img class="shape-image one" src="{{asset ('assets/images/banner/banner__business__mail__image-sm1.svg') }}" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- shared hosting banner end-->

    <!-- KNOWLEDGE BASE ITEM -->
    <div class="rts-knowledgebase pt--120 pb--60">
        <div class="container">
            <div class="row g-5">
                <div class="col-xl-4 col-lg-5">
                    <div class="rts-sidebar">
                        <div class="rts-single-widget category-widget knowledge__tab__section">
                            <h4 class="widget-title">Knowledgebase</h4>
                            <ul class="list-unstyled cat__counter nav nav-tabs" id="myTab" role="tablist">

                                @foreach ($knowledgebases as $index => $knowledgebase)
                                <li class="single-cat nav-item" role="presentation">
                                    <button class="button-tab" id="knowledgebase{{$index}}" data-bs-toggle="tab" data-bs-target="#knowledgebase{{$index}}-tab" type="button" role="tab" aria-controls="knowledgebase{{$index}}" aria-selected="true" tabindex="0">{{$knowledgebase->title_en}} <span>({{$knowledgebase->contents->count()}})</span></button>
                                </li>
                                @endforeach


                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-8 col-lg-7">
                    <div class="tab-content" id="myTabContent">
                        @foreach ($knowledgebases as $index => $kb)
                        <div class="tab-pane fade @if ($index == 0 )active show @endif  knowledge__content"
                        id="knowledgebase{{$index}}-tab" role="tabpanel" aria-labelledby="knowledgebase{{$index}}">
                            <div class="content-list">
                                @foreach ($kb->contents as $content)
                                <div class="single-content">
                                    <h5>{{$kb->title_en}}</h5>
                                    <p class="icon-text"><span><i class="fa-regular fa-file-lines"></i></span>
                                        {{$content->title_en}}</p>
                                    <p>{{$content->body_en}}</p>
                                </div>

                                @endforeach

                            </div>
                        </div>
                        @endforeach


                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- KNOWLEDGE BASE ITEM END -->

    <!-- SUPPORT AREA -->
    <div class="rts-support pb--60">
        <div class="container">
            <div class="row">
                <div class="rts-support__wrapper bg-white">
                    <div class="rts-support__wrapper--content">
                        <h3 class="title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">24/7 World-Class Support</h3>
                        <p data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Ran into trouble? Contact our Customer Success team any
                            time via live chat or email.
                        </p>
                        <div class="feature" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                            <ul class="feature__list">
                                <li class="feature__item">Receive professional WordPress support</li>
                                <li class="feature__item">Our specialists are available round</li>
                            </ul>
                        </div>
                        <a href="{{route('support')}}" class="rts-btn rts-btn-primary support-btn">Get Support <i class="fa-regular fa-chevron-right"></i></a>
                    </div>
                    <div class="rts-support__wrapper--image" data-sal="slide-left" data-sal-delay="400" data-sal-duration="800">
                        <img src="{{asset ('assets/images/support/support__image.svg') }}" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- SUPPORT AREA END -->

    <!-- HOSTIE CTA -->
    <div class="rts-cta-two shared-page-bg ">
        <div class="container">
            <div class="row">
                <div class="rts-cta-two__wrapper">
                    <div class="cta__shape"></div>
                    <div class="cta-content">
                        <span data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Need help choosing a plan?</span>
                        <h4 data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Need help?
                            We're always here for you.</h4>
                    </div>
                    <div class="cta-btn">
                        <a href="#" class="contact__us primary__btn btn__two secondary__bg secondary__color">Go to Live chat Page</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- HOSTIE CTA END -->


    <!-- FOOTER AREA -->
    @include('Frontend.Includes.Footers.footerOne')
    <!-- FOOTER AREA END -->
@endsection
