@extends('Frontend.Layouts.app')
@section('title', 'تبادل الإرادة')
@section('content')
    <!-- HEADER AREA -->
    @include('Frontend.Includes.navbar')
    <!-- HEADER AREA END -->

    <div class="site-content">

        <div class="container-fluid">
            <div class="item-efftect">
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
            </div>
        </div>
        @php
            $setting = App\Models\Home_setting::first();
        @endphp
        <!--=================================
              Main Banner -->
        <!-- Swiper Wrapper -->
        <div class="swiper banner-swiper">
            <div class="swiper-wrapper">

                @php
                    $sliders = App\Models\Slider::where('status', 1)->latest()->limit(3)->get();
                    $image = 'image_'.app()->getLocale();
                    $subtitle = 'subtitle_'.app()->getLocale();
                    $title = 'title_'.app()->getLocale();
                    $btn = 'btn_'.app()->getLocale();
                @endphp
                @foreach($sliders as $slider)
                <div class="swiper-slide">
                    <div class="main-banner main-banner-3">
                        <img class="img-fluid banner-bg"
                             src="{{ asset('storage/files/' . ($slider->$image ?? 'default.png')) }}" alt="">
                        <div class="overlay"></div>

                        <div class="container-fluid g-md-0">
                            <div class="banner-inner">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="banner-conent">
                  <span class="sub-title">
                    {{ $slider->$subtitle }}
                  </span>
                                            <h1 class="title">
                                                {{ $slider->$title }}
                                            </h1>

                                            <div class="banner-conent-footer">
                                                <div class="attract-hover">
                                                    <div class="attract-hover-easing">
                                                        <a class="custom-btn" href="{{ $slider->url }}" style="background: #990f8d; border: 1px solid #990f8d;">
                                                            {{ $slider->$btn  }}
                                                        </a>

                                                    </div>
                                                </div>

                                                @if($slider->clients == 1)
                                                <div class="clienti-reviews">
                                                    <ul class="clienti-profile">
                                                        <li><img class="img-fluid" src="{{ url('/') }}/front/images/avatar/01.jpg" alt=""></li>
                                                        <li><img class="img-fluid" src="{{ url('/') }}/front/images/avatar/02.jpg" alt=""></li>
                                                        <li><img class="img-fluid" src="{{ url('/') }}/front/images/avatar/03.jpg" alt=""></li>
                                                        <li><img class="img-fluid" src="{{ url('/') }}/front/images/avatar/04.jpg" alt=""></li>
                                                    </ul>
                                                    <div class="reviews"><span class="reviews-number">90+</span> <span>عميل سعيد بخدماتنا</span></div>
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> <!-- /.main-banner -->
                </div> <!-- /.swiper-slide -->
                @endforeach


            </div>

            <!-- Swiper Controls -->
            <div class="swiper-pagination"></div>

        </div>

        <div class="content-wrapper">

            <section class="space-pt z-index-2 ellipse-top bg-black pb-5 ">
                <div class="container">
                    <div class="row justify-content-between">
                        <div class="col-lg-5 text-lg-center mb-5 mb-lg-0">
                            <div class="about-img">
                                <img class="img-fluid" src="{{ url('/') }}/front/images/about/about-04.jpg" alt="#">
                                <div class="about-logo">
                                    <img class="img-fluid" src="{{asset('storage/files/' . ($setting->logo_secondary ?? 'default.png'))}}" style="width: 100px" alt="#">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="section-title">
                                <span class="sub-title"><img class="img-fluid" src="{{ url('/') }}/front/images/subtitle-icon.png" alt=""> {{ app()->getLocale() == 'ar' ? $setting->section2_title : $setting->section2_title_en }}</span>
                                <h2 class="title"> {{ app()->getLocale() == 'ar' ? $setting->section2_subtitle : $setting->section2_subtitle_en }} </h2>
                            </div>
                            <div class="ps-0 ps-lg-4 ps-xl-5">
                                <p>{!! app()->getLocale() == 'ar' ? $setting->section2_content : $setting->section2_content_en !!}</p>
                                <div class="skill-wrapper pt-2">
                                    <div class="skill skill-style-2">
                                        <div class="skill-bar progress-animated" data-percent="94" data-delay="0" data-type="%" style="width: 94%;">
                                            <div class="skill-title">نسبة انجاز المشاريع</div>
                                            <span class="progress-type animated fadeIn">%</span><span class="progress-number animated fadeIn">94</span></div>
                                    </div>
                                </div>
                                <div class="row align-items-center mt-4 pt-1">
                                    <div class="col-sm-8">
                                        <div class="list-wrapper">
                                            <ul class="list col-2">
                                                <li><img class="img-fluid" style="width: 20px;" src="{{ url('/') }}/front/images/arrow-left.png" alt="">حلول الذكاء الاصطناعي</li>
                                                <li><img class="img-fluid" style="width: 20px;" src="{{ url('/') }}/front/images/arrow-left.png" alt="">تطوير التطبيقات</li>
                                                <li><img class="img-fluid" style="width: 20px;" src="{{ url('/') }}/front/images/arrow-left.png" alt="">تصميم المواقع</li>
                                                <li><img class="img-fluid" style="width: 20px;" src="{{ url('/') }}/front/images/arrow-left.png" alt="">التسويق الرقمي</li>
                                                <li><img class="img-fluid" style="width: 20px;" src="{{ url('/') }}/front/images/arrow-left.png" alt="">إدارة الحملات الاعلانية</li>
                                                <li><img class="img-fluid" style="width: 20px;" src="{{ url('/') }}/front/images/arrow-left.png" alt="">مراكز الاتصال</li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-sm-4 text-sm-end mt-4 mt-sm-0">
                                        <img class="img-fluid" src="{{ url('/') }}/front/images/about/about-05.png" alt="#">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section class="space-small-ptb bg-light">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-10 text-center">
                            <div class="section-title">
                                <h2 class="title"> {{ __('lang.We make technology work for you') }}
                                </h2>
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-start">
                        <div class="col-lg-12">
                            <div class="services grid-wrapper grid-xl-3 grid-lg-3 grid-md-2 grid-sm-1">
                                @php
                                    $services = App\Models\Service::where('status', 1)->latest()->limit(9)->get();

                                @endphp
                                @foreach ($services as $service)
                                    <div class="service-wrapper service-style-1">
                                        <div class="service-inner">
                                            <div class="service-icon">
                                                <img class="img-fluid" src="{{asset('front/images/svg/services/Content-Management.svg')}}"
                                                     alt="#">
                                            </div>
                                            <div class="bg-icon">
                                                <img class="img-fluid" src="{{asset('front/images/svg/services/color-icon/Content-Management.svg')}}"
                                                     alt="#">
                                            </div>
                                            <div class="service-content">
                                                <h5 class="service-title">
                                                    {{ app()->getLocale() == 'ar' ? $service->title : $service->title_en }}</small>

                                                </h5>
                                                <p>
                                                    {{ app()->getLocale() == 'ar' ? $service->body : $service->body_en }}</small>

                                                </p>
                                            </div>
                                        </div>
                                    </div>

                                @endforeach


                            </div>
                        </div>
                    </div>
                </div>
            </section>


            <section class="space-small-ptb ellipse-top ellipse-bottom">
                <div class="container">
                    <div class="row justify-content-start">
                        <div class="section-title pb-0 pb-lg-4">
                            <h3 class="title">
                                {{ app()->getLocale() == 'ar' ? $setting->section5_title : $setting->section5_title_en }}
                            </h3>
                            <span class="title">
                                {{ app()->getLocale() == 'ar' ? $setting->section5_subtitle : $setting->section5_subtitle_en }}
                            </span>
                        </div>
                        <div class="col-lg-12">
                            <div class="blog-items grid-wrapper grid-xl-3 grid-md-2 grid-sm-1">
                                @php
                                    if (app()->getLocale() == 'ar') {
                                        $works = App\Models\Work::where('status', 1)
                                            ->where('language_id', 2)
                                            ->latest()
                                            ->limit(3)
                                            ->get();
                                    } else {
                                        $works = App\Models\Work::where('status', 1)
                                            ->where('language_id', 1)
                                            ->latest()
                                            ->limit(3)
                                            ->get();
                                    }
                                @endphp
                                @foreach ($works as $work)
                                    <div class="blog-post-wrapper blog-style-1">
                                        <div class="blog-post-info">
                                            <h5 class="post-title"><a href="{{ route('front.work', $work->id) }}">
                                                    {{ $work->title }}</a></h5>
                                            <p class="post-title"> {{ $work->category }} </p>
                                        </div>
                                        <div class="blog-post-img"><img class="img-fluid"
                                                src="{{ asset('storage/files/' . ($work->image ?? 'default.png')) }}"
                                                alt=""></div>
                                    </div>
                                @endforeach




                            </div>
                            <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                <a class="btn btn-effect btn-primary" href="{{route('front.our_work')}}">
                                    <span>{{__('lang.See all projects')}}</span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                      transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
            </section>

            <!-- قسم آراء العملاء -->
            <section class="py-5 bg-light">
                <div class="container">
                    <div class="row justify-content-center mb-4">
                        <div class="col-md-12 section-title ">
                            <h3 class="text-muted title">
                                {{ app()->getLocale() == 'ar' ? $setting->section6_title : $setting->section6_title_en }}
                            </h3>
                            <h5 class="fw-bold">
                                {{ app()->getLocale() == 'ar' ? $setting->section6_subtitle : $setting->section6_subtitle_en }}
                            </h5>
                        </div>
                    </div>
                    <div class="row g-4">
                        @php
                            $opinions = App\Models\Opinion::latest()->limit(6)->get();
                        @endphp
                        @foreach ($opinions as $opinion)
                            <div class="col-md-6 col-lg-4">
                                <div class="border rounded-4 p-4 bg-white h-100">
                                    <p class="mb-3">
                                        {{ app()->getLocale() == 'ar' ? $opinion->content : $opinion->content_en }} </p>
                                    <h6 class="mb-0 fw-semibold">
                                        {{ app()->getLocale() == 'ar' ? $opinion->name : $opinion->name_en }}</h6>
                                    <small class="text-muted">
                                        {{ app()->getLocale() == 'ar' ? $opinion->category : $opinion->category_en }}</small>
                                </div>
                            </div>
                        @endforeach


                    </div>
                    <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                        <a class="btn btn-effect btn-primary" href="{{route('front.Opinion')}}">
                            <span>{{__('lang.See More')}}</span>
                            <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_59_253)">
                                    <path
                                        d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                        stroke="white" stroke-width="2" />
                                    <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_59_253">
                                        <rect width="21.3333" height="20" fill="white"
                                            transform="translate(20) rotate(90)" />
                                    </clipPath>
                                </defs>
                            </svg>
                        </a>
                    </div>
                </div>
            </section>



            <section class="space-small-ptb">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="section-title">
                                <h2 class="title">
                                    {{ app()->getLocale() == 'ar' ? $setting->section8_title : $setting->section8_title_en }}
                                </h2>
                                <p class="title">
                                    {{ app()->getLocale() == 'ar' ? $setting->section8_subtitle : $setting->section8_subtitle_en }}
                                </p>
                            </div>
                            <div class="ps-xxl-5 ms-0 ms-md-5">
                                <a class="btn btn-effect" href="{{route('front.plans')}}">
                                    <span> {{__('lang.Browse packages')}}</span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                    transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        @php
                            $plans = App\Models\Plan::where('status', 1)->latest()->limit(3)->get();
                            $allFeatures = App\Models\Feature::all();
                        @endphp
                        <div class="col-lg-7 ps-xxl-5">
                            <div class="pgs-accordion pgs-pricing ps-0 ps-lg-5 mt-5 mt-lg-0 mb-5">
                                @foreach ($plans as $index => $plan)
                                    <div class="accordion-item @if ($index == 0) is-active @endif">
                                        <div class="accordion-header">
                                            <div class="package-info">
                                                <span class="package-check"><i class="fa-solid fa-check"></i></span>
                                                <div class="package-name">
                                                    <h5 class="package-title">
                                                        {{ app()->getLocale() == 'ar' ? $plan->title_ar : $plan->title_en }}
                                                    </h5>
                                                    <span
                                                        class="package-discount">{{ app()->getLocale() == 'ar' ? $plan->description_ar : $plan->description_en }}</span>
                                                </div>
                                            </div>
                                            <div class="package-price">
                                                <img class="img-fluid" width="170"
                                                    src="{{ asset('storage/files/' . ($plan->image ?? 'default.png')) }}"
                                                    alt="logo">
                                            </div>
                                        </div>
                                        <div class="accordion-content">
                                            <div class="content-inner">
                                                <div class="pricing-lists">
                                                    <ul class="pricing-lists">
                                                        @foreach ($allFeatures as $feature)
                                                            @if (in_array($feature->id, $plan->features))
                                                                <li><i class="fa-regular fa-circle-check"></i>
                                                                    {{ app()->getLocale() == 'ar' ? $feature->title_ar : $feature->title_en }}
                                                                </li>
                                                            @endif
                                                        @endforeach
                                                    </ul>
                                                </div>
                                                <div class="pricing-link">
                                                    <a href="{{route('front.form')}}"><svg width="17" height="16"
                                                            viewBox="0 0 17 16" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <g clip-path="url(#clip0_923_1331)">
                                                                <path
                                                                    d="M8.70801 0.959961L9.29825 2.7665C10.2512 5.68321 12.8308 7.77453 15.8928 8.1128C12.8468 8.37564 10.2578 10.4348 9.3276 13.3343L8.70801 15.2657"
                                                                    stroke="inherit" stroke-width="1" />
                                                                <path d="M15.7602 8.12158H0.1875" stroke="inherit"
                                                                    stroke-width="1" />
                                                            </g>
                                                            <defs>
                                                                <clipPath id="clip0_923_1331">
                                                                    <rect width="15.904" height="14.8437" fill="inherit"
                                                                        transform="translate(0.1875 0.578125)" />
                                                                </clipPath>
                                                            </defs>
                                                        </svg></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach

                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section class="py-5 bg-light">
                <div class="container">
                    <div class="row justify-content-center mb-4">
                        <div class="col-md-12 section-title ">
                            <h3 class="text-muted title">
                                {{ app()->getLocale() == 'ar' ? $setting->section7_title : $setting->section7_title_en }}
                            </h3>
                            <p class="text-muted title">
                                {{ app()->getLocale() == 'ar' ? $setting->section7_title : $setting->section7_title_en }}
                            </p>
                        </div>
                    </div>
                    @php
                        if (app()->getLocale() == 'ar') {
                            $blogs = App\Models\Blog::where('popular', 1)
                                ->where('status', 1)
                                ->where('language_id', 2)
                                ->latest()
                                ->limit(3)
                                ->get();
                        } else {
                            $blogs = App\Models\Blog::where('popular', 1)
                                ->where('status', 1)
                                ->where('language_id', 1)
                                ->latest()
                                ->limit(3)
                                ->get();
                        }
                    @endphp
                    <div class="row g-4">
                        @foreach ($blogs as $blog)
                            <div class="col-lg-4 col-sm-12">
                                <div class="blog-post-wrapper blog-style-1">
                                    <div class="blog-post-img"><img class="img-fluid" style="height: 240px;"
                                            src="{{ asset('storage/files/' . ($blog->image ?? 'default.png')) }}"
                                            alt=""></div>
                                    <div class="blog-post-info">
                                        <h5 class="post-title"><a href="{{ route('front.blog', $blog->id) }}">
                                                {{ $blog->title }}</a></h5>
                                        <p class="post-title"> {{ $blog->category }} </p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                        <a class="btn btn-effect btn-primary" href="{{route('front.blogs')}}">
                            <span>{{ __('lang.Enter the Knowledge Center') }}</span>
                            <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_59_253)">
                                    <path
                                        d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                        stroke="white" stroke-width="2" />
                                    <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_59_253">
                                        <rect width="21.3333" height="20" fill="white"
                                            transform="translate(20) rotate(90)" />
                                    </clipPath>
                                </defs>
                            </svg>
                        </a>
                    </div>
                </div>
            </section>




            <!--=================================
                Contact Us -->
            <section class="space-small-ptb">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-5 col-xl-6">
                            <div class="section-title ">
                                <h3 class="title">تواصل
                                    معنا</h3>
                                <h5 class="title">
                                    {{ app()->getLocale() == 'ar' ? $setting->section9_title : $setting->section9_title_en }}
                                    </h6>
                                </h5>
                                <div class="social-icons" style="display: flex; gap: 40px;">
                                    <a href="{{ $setting->whatsapp }}" target="_blank" style="color: #25D366;">
                                        <i class="fab fa-whatsapp fa-lg"></i>
                                    </a>
                                    <a href="{{ $setting->facebook }}" target="_blank" style="color: #3b5998;">
                                        <i class="fab fa-facebook-f fa-lg"></i>
                                    </a>
                                    <a href="{{ $setting->twitter }}" target="_blank" style="color: #1DA1F2;">
                                        <i class="fab fa-twitter fa-lg"></i>
                                    </a>
                                    <a href="{{ $setting->instagram }}" target="_blank" style="color: #C13584;">
                                        <i class="fab fa-instagram fa-lg"></i>
                                    </a>
                                    <a href="{{ $setting->linkedin }}" target="_blank" style="color: #0077b5;">
                                        <i class="fab fa-linkedin-in fa-lg"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="widget widget-address-info">
                                <ul class="address-info-list address-info-2">
                                    <li><i class="icon"><img class="img-fluid"
                                                src="{{ asset('front/images/svg/address-info-headphone.svg') }}"
                                                alt=""></i><span class="info"><span><a
                                                    href="tel:{{ $setting->phone }}">{{ $setting->phone }}</a> </li>
                                    <li><i class="icon"><img class="img-fluid"
                                                src="{{ asset('front/images/svg/address-info-email.svg') }}"
                                                alt=""></i><span class="info"><span><a
                                                    href="mailto:{{ $setting->email }}">{{ $setting->email }}</a></span>24x7
                                        </span></li>
                                </ul>

                            </div>


                            <p class="title mb-0">
                                {{ app()->getLocale() == 'ar' ? $setting->section9_subtitle : $setting->section9_subtitle_en }}
                            </p>
                            <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                <a class="btn btn-primary" href="#">
                                    <span> {{ __('lang.Book a consultation') }}</span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                    transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-7 col-xl-6">
                            <div class="form-wrapper form-box bg-black mt-5 mt-lg-0 z-index-2">
                                <div class="section-title">
                                    <h4 class="title mb-0">{{ __('lang.Quick contact form:') }} </h4>
                                </div>
                                <form class="contact-form form-style-border">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control" placeholder="{{__('lang.Name')}}"
                                                aria-label="Name">
                                        </div>
                                        <div class="col-sm-6">
                                            <input type="email" class="form-control" placeholder="{{__('lang.Email')}}"
                                                aria-label="Email" required>
                                        </div>
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control" id="phone"
                                                placeholder="{{__('lang.Phone')}}" required>
                                        </div>
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control" id="Subject"
                                                placeholder="{{__('lang.Subject')}}">
                                        </div>
                                        <div class="col-lg-12">
                                            <textarea class="form-control" rows="3" placeholder="{{__('lang.Describe your message')}}*"></textarea>
                                        </div>
                                        <div class="d-flex justify-content-center ms-sm-5 ms-0">
                                            <button type="submit" class="btn btn-primary" href="#">
                                                <span>{{__('lang.Send now')}}</span>
                                                <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <g clip-path="url(#clip0_59_253)">
                                                        <path
                                                            d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                            stroke="white" stroke-width="2" />
                                                        <path d="M9.83594 20.8889L9.83594 0" stroke="white"
                                                            stroke-width="2" />
                                                    </g>
                                                    <defs>
                                                        <clipPath id="clip0_59_253">
                                                            <rect width="21.3333" height="20" fill="white"
                                                                transform="translate(20) rotate(90)" />
                                                        </clipPath>
                                                    </defs>
                                                </svg>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="space-small-ptb ellipse-top bg-black z-index-2" >
                <div class="container">
                    <div class="row mb-lg-5">
                        <div class="col-xxl-6 col-lg-8">
                            <div class="section-title mb-lg-0">
                                <span
                                    class="sub-title">{{ app()->getLocale() == 'ar' ? $setting->section10_title : $setting->section10_title_en }}</span>
                                <h2 class="title mb-0">
                                    {{ app()->getLocale() == 'ar' ? $setting->section10_subtitle : $setting->section10_subtitle_en }}
                                </h2>
                            </div>
                        </div>
                        <div class="col-xxl-6 col-lg-4 align-self-end">
                            <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                <a class="btn btn-primary" href="{{route('front.form')}}">
                                    <span>{{__('lang.start now')}}</span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                    transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        </div>
    </div>


    @include('Frontend.Includes.Footer')
    <!-- FOOTER AREA END -->

    <script>
        const swiper = new Swiper('.banner-swiper', {
            loop: true,
            autoplay: {
                delay: 6000,
                disableOnInteraction: false,
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev'
            },
            effect: 'fade',
            fadeEffect: {
                crossFade: true
            }
        });
    </script>

@endsection
