@extends('Frontend.Layouts.app')
@section('title', 'Blog Details')
@section('content')
    <!-- HEADER AREA -->
        @include('Frontend.Includes.Headers.headerOne')
    <!-- HEADER AREA END -->

    <!-- shared hosting banner -->
    <div class="rts-hosting-banner rts-hosting-banner-bg banner-default-height">
        <div class="container">
            <div class="row">
                <div class="banner-area">
                    <div class="rts-hosting-banner rts-hosting-banner__content blog__banner">
                        <span class="starting__price">Blog & Article </span>
                        <h1 class="banner-title">
                            Latest News & Articale
                        </h1>
                        <p class="slogan">You can also do this by logging into a server directly, but the process requires some technical knowledge since a single mistake can break your entire site...</p>
                        <div class="hosting-action">
                            <a href="{{route ('blogDetails',1) }}" class="btn__two secondary__bg secondary__color">View Details <i class="fa-regular fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="rts-hosting-banner__image blog">
                        <img src="{{asset ('assets/images/banner/banner__blog__image.svg') }}" alt="">
                        <img class="shape one left-right" src="{{asset ('assets/images/banner/banner__blog__image-sm1.svg') }}" alt="">
                        <img class="shape two show-hide" src="{{asset ('assets/images/banner/banner__blog__image-sm2.svg') }}" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- shared hosting banner end-->

    <!-- BLOG DETAILS -->
    <div class="rts-blog-details section__padding">
        <div class="container">
            <div class="row g-40">
                <div class="col-lg-8">
                    <article class="blog-details">
                        <div class="blog-details__featured-image">
                            <img src="{{ asset('storage/files/' . $blog->image) }}" alt="blog post">
                        </div>
                        <div class="blog-details__article-meta mt--40">
                            <span><span><i class="fa-light fa-clock"></i></span>{{$blog->created_at->format('d-M-y')}}</span>
                            <a href="#"><span><i class="fa-sharp fa-light fa-tags"></i></span>{{$blog->category}}</a>
                        </div>
                        <h3 class="blog-title">{{$blog->title }}</h3>

                        {!!$blog->content !!}
                    </article>
                    <div class="blog-info">
                        <div class="blog-tags">
                            <div class="tags-title">tags:</div>
                            @php
                            $tags = explode(',', $blog->tags);
                        @endphp

                        <div class="blog-tags__list">
                            @foreach ($tags as $tag)
                                <a href="#">{{ ucfirst(trim($tag)) }}</a>
                            @endforeach
                        </div>
                        </div>
                        <div class="blog-share">
                            <div class="share">Share:</div>
                            <div class="social__media--list">
                                @php
                                    $shareUrl = urlencode(route('blogDetails', $blog->id));
                                @endphp

                                <a href="https://www.facebook.com/sharer/sharer.php?u={{ $shareUrl }}" target="_blank" class="media">
                                    <i class="fa-brands fa-facebook-f"></i>
                                </a>
                                <a href="https://www.instagram.com/?url={{ $shareUrl }}" target="_blank" class="media">
                                    <i class="fa-brands fa-instagram"></i>
                                </a>
                                <a href="https://www.linkedin.com/sharing/share-offsite/?url={{ $shareUrl }}" target="_blank" class="media">
                                    <i class="fa-brands fa-linkedin"></i>
                                </a>
                                <a href="https://twitter.com/intent/tweet?url={{ $shareUrl }}" target="_blank" class="media">
                                    <i class="fa-brands fa-twitter"></i>
                                </a>
                                <a href="https://www.behance.net/" target="_blank" class="media">
                                    <i class="fa-brands fa-behance"></i>
                                </a>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="rts-sidebar">
                        <!-- single widget start -->
                        <div class="rts-single-widget recentpost-widget">
                            <h4 class="widget-title">Recent Post</h4>
                            <div class="recent-posts">
                                @foreach ($blogs as $r_blog)
                                <div class="single-post">
                                    <div class="thumb">
                                        <img src="{{ asset('storage/files/' . $r_blog->image) }}" alt="" height="85" width="85">
                                    </div>
                                    <div class="meta">
                                        <span class="published"><i class="fa-regular fa-clock"></i> {{$r_blog->created_at->format('d-M-y')}}</span>
                                        <h6 class="title"><a href="{{route ('blogDetails', $r_blog->id ) }}">{{$r_blog->title }}</a></h6>
                                    </div>
                                </div>
                                @endforeach

                            </div>
                        </div>
                        <!-- single widget end -->


                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- BLOG DETAILS END -->

    <!-- BLOG END -->

    <!-- FOOTER AREA -->
    @include('Frontend.Includes.Footers.footerOne')
    <!-- FOOTER AREA END -->
@endsection
