@extends('Frontend.Layouts.app')
@section('title', 'Blog')
@section('content')
    <!-- HEADER AREA -->
        @include('Frontend.Includes.Headers.headerOne')
    <!-- HEADER AREA END -->

    <!-- shared hosting banner -->
    <div class="rts-hosting-banner rts-hosting-banner-bg banner-default-height">
        <div class="container">
            <div class="row">
                <div class="banner-area">
                    <div class="rts-hosting-banner rts-hosting-banner__content blog__banner">
                        <span class="starting__price">Blog & Article </span>
                        <h1 class="banner-title">
                            Latest News & Articale
                        </h1>
                        <p class="slogan">You can also do this by logging into a server directly, but the process requires some technical knowledge since a single mistake can break your entire site...</p>
                        <div class="hosting-action">
                            <a href=" " class="btn__two secondary__bg secondary__color">View Details <i class="fa-regular fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="rts-hosting-banner__image blog">
                        <img src="{{asset ('assets/images/banner/banner__blog__image.svg') }}" alt="">
                        <img class="shape one left-right" src="{{asset ('assets/images/banner/banner__blog__image-sm1.svg') }}" alt="">
                        <img class="shape two show-hide" src="{{asset ('assets/images/banner/banner__blog__image-sm2.svg') }}" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- shared hosting banner end-->

    <!-- BLOG -->
    <section class="rts-blog pt-120">
        <div class="container">
            <div class="row justify-content-sm-center justify-content-md-start g-30">
                @php
                    $blogs = App\Models\Blog::where('status',1)->latest()->get();
                @endphp
                @foreach ($blogs as $blog)
                <div class="col-lg-4 col-md-6 col-sm-10">
                    <div class="rts-blog__single">
                        <a href="{{route ('blogDetails', $blog->id ?? 1 ) }}">
                            <img class="blog__thumb" src="{{ asset('storage/files/' . $blog->image) }} " alt="blog post thumb">
                        </a>
                        <div class="rts-blog__single--meta">
                            <div class="cat__date">
                                <a href="#" class="cat">{{$blog->category}}</a>
                                <span class="date">{{$blog->created_at->format('d-M-y')}}</span>
                            </div>
                            <a href="{{route ('blogDetails', $blog->id ?? 1 ) }}" class="title">{{$blog->title}}</a>

                        </div>
                    </div>
                </div>
                @endforeach


            </div>
            {{-- <div class="blog-pagination-area">
                <ul>
                    <li><a href="#"><i class="fa-regular fa-chevron-left"></i></a></li>
                    <li><a class="active" href="#">1</a></li>
                    <li><a href="#">2</a></li>
                    <li><a href="#">3</a></li>
                    <li>...</li>
                    <li><a href="#">8</a></li>
                    <li><a href="#">9</a></li>
                    <li><a href="#"><i class="fa-regular fa-chevron-right"></i></a></li>
                </ul>
            </div> --}}
        </div>
    </section>
    <!-- BLOG END -->
    <!-- FOOTER AREA -->
    @include('Frontend.Includes.Footers.footerOne')
    <!-- FOOTER AREA END -->
@endsection
