@php
    $setting = App\Models\Home_setting::select('logo','logo_secondary','phone','email','address','footer','footer_en','whatsapp'
    ,'facebook','instagram','linkedin','twitter','site_name','site_name_en')->first();
@endphp
<footer class="site-footer footer-dark">
  <div class="footer-main">
    <div class="container">
      <div class="row">
        <div class="col-xl-3 col-md-5">
          <div class="widget widget-address-info">
            <h5 class="widget-title">{{ app()->getLocale() == 'ar' ? $setting->footer : $setting->footer_en }}</h5>
            <ul class="address-info-list">
              <li><i class="icon"><img class="img-fluid" src="{{asset('front/images/svg/address-info-contacts.svg')}}" alt=""></i><span
                  class="info"><span> </span>{{$setting->address}}</span></li>
              <li><i class="icon"><img class="img-fluid" src="{{asset('front/images/svg/address-info-headphone.svg')}}" alt=""></i><span
                  class="info"><span><a href="tel:{{$setting->phone}}">{{$setting->phone}}</a> </span></li>
              <li><i class="icon"><img class="img-fluid" src="{{asset('front/images/svg/address-info-email.svg')}}" alt=""></i><span
                  class="info"><span><a href="mailto:{{$setting->email}}">{{$setting->email}}</a></span>24x7  </span></li>
            </ul>
          </div>
        </div>

        <div class="col-xl-6 col-md-7">
          <div class="widget">
            <div class="widget widget-menu">
              <h6 class="widget-title">{{__('lang.Quick Links')}}</h6>
              <ul class="list-unstyled list-col-3 mb-0">
                <li><a href="{{route('front.services')}}">{{__('lang.Services')}}</a></li>
                <li><a href="{{route('front.plans')}}">{{__('lang.Plans')}}</a></li>
                <li><a href="{{route('about')}}">{{__('lang.About Us')}}</a></li>
                <li><a href="{{route('front.Opinion')}}">{{__('lang.Opinion')}}</a></li>
                <li><a href="{{route('front.faq')}}">{{__('lang.FAQ')}}</a></li>
                <li><a href="{{route('front.contact')}}"> {{__('lang.Contact us')}}</a></li>
                <li><a href="{{route('front.our_work')}}">{{__('lang.Our work')}}</a> </li>
                <li><a href="{{route('front.Terms_of_Service')}}">{{__('lang.Terms of Service')}} </a> </li>
                <li><a href="{{route('front.Terms_of_Use')}}">{{__('lang.Terms of Use')}} </a> </li>
                <li><a href="{{route('front.Privacy')}}">{{__('lang.Privacy')}} </a> </li>
                <li><a href="{{route('front.blogs')}}">{{__('lang.Blog')}} </a> </li>
              </ul>
            </div>
          </div>
        </div>
        <div class="col-xl-2 col-md-12 ms-auto">
            <p><a class="footer-logo" href="{{route('home')}}"><img class="img-fluid" src="{{asset('storage/files/' . ($setting->logo_secondary ?? 'default.png'))}}" alt="logo"></a></p>

          <div class="widget-socail">
            <div class="social-icons" style="display: flex; gap: 40px;">
                <a href="{{$setting->whatsapp}}" target="_blank" style="color: #CECECE;">
                    <i class="fab fa-whatsapp fa-lg"></i>
                </a>
                <a href="{{$setting->facebook}}" target="_blank" style="color: #CECECE;">
                    <i class="fab fa-facebook-f fa-lg"></i>
                </a>
                <a href="{{$setting->twitter}}" target="_blank" style="color: #CECECE;">
                    <i class="fab fa-twitter fa-lg"></i>
                </a>
                <a href="{{$setting->instagram}}" target="_blank" style="color: #CECECE;">
                    <i class="fab fa-instagram fa-lg"></i>
                </a>
                <a href="{{$setting->linkedin}}" target="_blank" style="color: #CECECE;">
                    <i class="fab fa-linkedin-in fa-lg"></i>
                </a>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
  <div class="footer-copyright">
    <div class="container">
      <div class="row align-items-center">

        <div class="col-lg-12 text-lg-center">
          <p>شركة تبادل الإرادة لتقنية المعلومات © 2025 جميع الحقوق محفوظة</p>
        </div>
      </div>
    </div>
  </div>
</footer>

<!--=================================
    Back To Top -->
<div class="back-to-top">
  <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
    <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
  </svg>
</div>
