<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class InputField extends Component
{
    /**
     * Create a new component instance.
     */
    public $label;
    public $name;
    public $value;
    public $required;
    public $maxLength;
    public $error;
    public $type;
    public $col;

    public function __construct( $label,
    $name,
    $value = "",
    $required = false,
    $maxLength = 255,
    $error = null,
    $type = "text",
    $col = 12)
    {
        $this->label = $label;
        $this->name = $name;
        $this->value = $value;
        $this->required = $required;
        $this->maxLength = $maxLength;
        $this->error = $error;
        $this->col = $col;
        $this->type = $type;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.input-field');
    }
}
