<?php

namespace App\Http\Controllers\FrontendController;

use App\Models\Blog;
use App\Models\Work;
use App\Models\Page_setting;
use Illuminate\Http\Request;
use App\Models\Knowledgebase;
use App\Http\Controllers\Controller;

class PageController extends Controller
{

    public function home(){
        return view('Frontend.Pages.home');
    }
    public function about(){
        return view('Frontend.Pages.about');
    }
    // Pricing
    public function Opinion(){
        return view('Frontend.Pages.Opinion');
    }

    public function faq(){
        return view('Frontend.Pages.faq');
    }
    public function services(){
        return view('Frontend.Pages.services' );
    }
    // Contact
    public function contact(){

        return view('Frontend.Pages.contact' );
    }

    public function plans(){

        return view('Frontend.Pages.plans' );
    }
    public function our_work(){

        return view('Frontend.Pages.our_work' );
    }

    public function blogs(){

        return view('Frontend.Pages.blogs' );
    }

    public function work($id){
        $work = Work::find($id);
        if($work){
            return view('Frontend.Pages.single_work',compact('work') );
        }else{
            return redirect()->back();
        }

    }

    public function blog($id){
        $blog = Blog::find($id);
        if($blog){
            return view('Frontend.Pages.single_blog',compact('blog') );
        }else{
            return redirect()->back();
        }

    }
    // knowledgebase
    public function knowledgebases($id){
         $knowledgebase = Knowledgebase::find($id);
        if($knowledgebase){
            return view('Frontend.Pages.single_knowledgebase',compact('knowledgebase') );
        }else{
            return redirect()->back();
        }

    }
    // hostingOffer
    public function Terms_of_Service(){
        $content = Page_setting::select('t_s_content','t_s_content_en')->first();
        return view('Frontend.Pages.Terms_of_Service', compact('content'));
    }
    public function PrMontserratcy(){
        $content = Page_setting::select('s_content','s_content_en')->first();
        return view('Frontend.Pages.PrMontserratcy', compact('content'));
    }
    public function Terms_of_Use(){
        $content = Page_setting::select('t_u_content','t_u_content_en')->first();
        return view('Frontend.Pages.Terms_of_Use', compact('content'));
    }
    public function form(){
        return view('Frontend.Pages.form');
    }

    public function store(Request $request)
{
    $request->validate([
        'name' => 'required|string|max:255',
        'email' => 'required|email|max:255',
        'phone' => 'required|string|max:20',
        'type' => 'required|in:service,plan,consultation',
    ]);

    $exists = \App\Models\Order::where('email', $request->email)
        ->orWhere('phone', $request->phone)
        ->exists();

    if ($exists) {
        return response()->json([
            'status' => 'exists',
            'message' => __('lang.The phone number or email has already been used.'),
        ]);
    }

    $order = \App\Models\Order::create([
        'name' => $request->name,
        'email' => $request->email,
        'phone' => $request->phone,
        'type' => $request->type,
        'related_id' => $request->related_id,
        'notes' => $request->notes,
        'is_featured' => false,
        'status' => 'new',
    ]);

    return response()->json([
        'status' => 'success',
        'message' => __('lang.Your request has been sent successfully!'),
    ]);
}
public function contact_store(Request $request)
{
    $request->validate([
        'name' => 'nullable|string|max:255',
        'email' => 'nullable|email|max:255',
        'phone' => 'required|string|max:20',
        'subject' => 'nullable|string|max:255',
        'message' => 'required|string|max:5000',

    ]);

    $exists = \App\Models\Message::where('email', $request->email)
        ->orWhere('phone', $request->phone)
        ->exists();

    if ($exists) {
        return response()->json([
            'status' => 'exists',
            'message' => __('lang.The phone number or email has already been used.'),
        ]);
    }

    $message = \App\Models\Message::create([
        'name' => $request->name,
        'email' => $request->email,
        'phone' => $request->phone,
        'subject' => $request->subject,
        'message' => $request->message,
    ]);

    return response()->json([
        'status' => 'success',
        'message' => __('lang.Your request has been sent successfully!'),
    ]);
}
}
