<?php

namespace App\Http\Controllers\admin;

use App\Models\Opinion;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class OpinionController extends Controller
{
    public function index()
    {
        $opinions = Opinion::latest()->get();
        return view('admin.opinion.opinions',compact('opinions'));
    }


    public function create()
    {
        $modalContent = view('admin.opinion.create_opinion' )->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {
       $validated = $request->validate([
            'name' => 'nullable|string|max:255',
            'nickname' => 'nullable|string|max:255',
            'category'   => 'nullable|string|max:255',
            'content'   => 'nullable|string',
            'name_en' => 'nullable|string|max:255',
            'nickname_en' => 'nullable|string|max:255',
            'category_en'   => 'nullable|string|max:255',
            'content_en'   => 'nullable|string',
        ]);
        Opinion::create($validated);
        $notification = trans('Created Successfully');
        return response()->json(['redirect_url' => route('opinion.index'),
        'notification' => $notification ]
    );
    }

    public function edit($id)
    {
        $opinion = Opinion::find($id);

        $modalContent = view('admin.opinion.edit_opinion',compact('opinion'))->render();
        return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $opinion = Opinion::find($id);
        $validated = $request->validate([
            'name' => 'nullable|string|max:255',
            'nickname' => 'nullable|string|max:255',
            'category'   => 'nullable|string|max:255',
            'content'   => 'nullable|string',
            'name_en' => 'nullable|string|max:255',
            'nickname_en' => 'nullable|string|max:255',
            'category_en'   => 'nullable|string|max:255',
            'content_en'   => 'nullable|string',
        ]);
        $opinion->update($validated);
        $notification = trans('Updated Successfully');
        return response()->json(['redirect_url' => route('opinion.index'),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $opinion = Opinion::find($id);
        $opinion->delete();
        $notification = trans('Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('opinion.index')->with($notification);
    }

}
