<?php

namespace App\Http\Controllers\admin;

use App\Models\KnowledgebaseContent;
use App\Models\Company;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class ContentsKController extends Controller
{

    public function create()
    {
        $modalContent = view('admin.knowledgebaseContent.create_knowledgebaseContent' )->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {

        // التحقق من المدخلات
        $validated = $request->validate([
            'knowledgebase_id' => 'required',
            'title_ar' => 'required|string|max:1000',
            'title_en' => 'required|string|max:1000',
            'body_ar' => 'required|string|max:10000',
            'body_en' => 'required|string|max:10000',
            'seo' => 'nullable|string|max:10000',

        ] );

     // إنشاء خدمة جديد
        KnowledgebaseContent::create($validated);

        $notification = trans(' Create Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function edit($id)
    {
        $knowledgebaseContent = KnowledgebaseContent::find($id);

        $modalContent = view('admin.knowledgebaseContent.edit_knowledgebaseContent',compact('knowledgebaseContent'))->render();
        return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $knowledgebaseContent = KnowledgebaseContent::find($id);

        $validated = $request->validate([
            'title_ar' => 'required|string|max:1000',
            'title_en' => 'required|string|max:1000',
            'body_ar' => 'nullable|string|max:10000',
            'body_en' => 'nullable|string|max:10000',
            'seo' => 'nullable|string|max:10000',

        ] );

        $knowledgebaseContent->update($validated);

        $notification = trans('Updated Successfully');
        return response()->json(['redirect_url' =>route('knowledgebase.contents', $knowledgebaseContent->knowledgebase_id ),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $knowledgebaseContent = KnowledgebaseContent::find($id);
        $knowledgebaseContent->delete();
        $notification = trans('Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

}
