@extends('layouts.dash_master')
@section('title')
    <title>{{ __('الطلبات') }}</title>
@endsection

@section('dash-content')
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">قائمة الطلبات</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">الرئيسية</a>
                            </li>
                            <li class="breadcrumb-item"> {{ __('الطلبات') }}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="orders-list-wrapper">
        <!-- orders List Items -->
        <div class="row" id="basic-table">
            <div class="col-12">

                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">التصنيفات</h4>
                    </div>
                    <div class="row card-body">
                        <x-select-field label="{{ __('النوع') }}" id="type" name="type"
                            :options="['service' => 'خدمة','plan' => 'باقة',
                                        'consultation' => 'إستشارة' ]" col="4"  />

                        <x-select-field label="{{ __('الحالة') }}" id="status" name="status"
                            :options="['new' => 'طلب جديد','urgent' => 'مستعجل','Completed' => 'مكتمل',
                                        'Cancelled' => 'ملغي','under_review' => 'تحت المراجعة' ]" col="4"   />
                            <div class="col-md-3 pt-2">
                                <button type="button" name="filter" id="filter" class="btn btn-primary">بحث</button>
                             </div>
                    </div>
                </div>
                <div class="card">

                    <div class="card-header">
                        <h4 class="card-title">قائمة الطلبات</h4>
                    </div>
                    <div class="row">
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive table-invoice">
                                        <table class="order-list-table table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>{{ __('الاسم') }}</th>
                                                    <th>{{ __('الهاتف') }}</th>
                                                    <th>{{ __('الايميل') }}</th>
                                                    <th>{{ __('النوع  ') }}</th>
                                                    <th>{{ __('الحالة') }}</th>
                                                    <th>{{ __('الملاحظة') }}</th>
                                                    <th>{{ __('العمليات') }}</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--/ orders List Items -->
        <a   data-id="1" class="btn btn-sm btn-icon order-edit btn-outline-primary" title="Edit">
            <i class="fa fa-edit"></i> تعديل
        </a>
    </div>
    <!-- Delete orders Modal -->
    <div class="modal fade modal-danger text-start" id="deleteorderModal" tabindex="-1" aria-labelledby="deleteordersLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deleteordersLabel">تأكيد حذف</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
                </div>
                <div class="modal-body">
                    <p>هل انت متأكد من انك تريد حذف هذه الميزة ؟ لايمكن التراجع عن العملية</p>
                </div>
                <div class="modal-footer">
                    <form method="POST" id="deleteorderForm">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">اغلاق</button>
                        <button type="submit" class="btn btn-danger"> حذف</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade text-start" id="ceratModal" tabindex="-1" aria-labelledby="ceratModal" >
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <!-- سيتم تحميل المحتوى هنا -->
            </div>
        </div>
    </div>
@endsection
@push('js')

    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/feather-icons/4.28.0/feather.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.order-list-table').DataTable().destroy();
            $('.order-list-table').DataTable({
                "processing": true,
                "serverSide": true,
                "lengthMenu": [
                    [10, 25, 50, 100, 250, 500],
                    [10, 25, 50, 100, 250, 500]
                ],
                ajax: {
                    url: "{{route('orders')}}",
                }, // JSON file to add data
                columns: [
                    // columns according to JSON

                    {
                        data: 'name'
                    },
                    {
                        data: 'phone'
                    },
                    {
                        data: 'email'
                    },
                    {
                        data: 'type'
                    },
                    {
                        data: 'status'
                    },
                    {
                        data: 'notes'
                    },
                    {
                        data: 'actions',
                        orderable: false
                    }
                ],

                order: [1, 'desc'],
                drawCallback: function(settings) {
                    $('.record__select').prop('checked', false);
                    $('#record__select-all').prop('checked', false);
                    $('#record-ids').val();
                    $('#bulk-delete').attr('disabled', true);
                },
                dom: '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                    '<"col-lg-12 col-xl-6" l>' +
                    '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                    '>t' +
                    '<"d-flex justify-content-between mx-2 row mb-1"' +
                    '<"col-sm-12 col-md-6"i>' +
                    '<"col-sm-12 col-md-6"p>' +
                    '>',
                language: {
                    sLengthMenu: 'Show _MENU_',
                    search: 'بحث',
                    searchPlaceholder: 'بحث..',
                    paginate: {
                        // remove previous & next text from pagination
                        previous: '&nbsp;',
                        next: '&nbsp;'
                    }
                },
                // Buttons with Dropdown
                buttons: [{
                        extend: 'collection',
                        className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                        text: feather.icons['share'].toSvg({
                            class: 'font-small-4 mr-50'
                        }) + 'تصدير',
                        buttons: [{
                                extend: 'print',
                                text: feather.icons['printer'].toSvg({
                                    class: 'font-small-4 mr-50'
                                }) + 'طباعة',
                                className: 'dropdown-item',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4, 5],
                                    modifier: {
                                        selected: true // تصدير الصفوف المحددة فقط
                                    }
                                },
                                customize: function(win) {
                                    $(win.document.body).prepend(
                                        '<h3 style="text-align:center;">الطلبات</h3>'
                                    );
                                    $(win.document.body).find('table')
                                        .addClass('compact')
                                        .css('font-size', '12px');
                                }
                            },
                            {
                                extend: 'excelHtml5',
                                text: feather.icons['file'].toSvg({
                                    class: 'font-small-4 mr-50'
                                }) + 'اكسل',
                                className: 'dropdown-item',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4, 5]
                                }
                            },
                        ],

                    },

                ],

            });
            $('#filter').click(function() {
                var type = $('#type').val();
                var status = $('#status').val();
                if (type != '' || status != '') {
                    $('.order-list-table').DataTable().destroy();
                    $('.order-list-table').DataTable({
                        "processing": true,
                        "serverSide": true,
                        "lengthMenu": [
                            [10, 25, 50, 100, 250, 500],
                            [10, 25, 50, 100, 250, 500]
                        ],
                        ajax: {
                            url: "{{route('orders')}}",
                            data: {
                                status: status,
                                type: type
                            }
                        }, // JSON file to add data
                        columns: [
                            // columns according to JSON

                            {
                                data: 'name'
                            },
                            {
                                data: 'phone'
                            },
                            {
                                data: 'email'
                            },
                            {
                                data: 'type'
                            },
                            {
                                data: 'status'
                            },
                            {
                                data: 'notes'
                            },
                            {
                                data: 'actions',
                                orderable: false
                            }
                        ],

                        order: [2, 'desc'],
                        drawCallback: function(settings) {
                            $('.record__select').prop('checked', false);
                            $('#record__select-all').prop('checked', false);
                            $('#record-ids').val();
                            $('#bulk-delete').attr('disabled', true);
                        },
                        dom: '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                            '<"col-lg-12 col-xl-6" l>' +
                            '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                            '>t' +
                            '<"d-flex justify-content-between mx-2 row mb-1"' +
                            '<"col-sm-12 col-md-6"i>' +
                            '<"col-sm-12 col-md-6"p>' +
                            '>',
                        language: {
                            sLengthMenu: 'Show _MENU_',
                            search: 'بحث',
                            searchPlaceholder: 'بحث..',
                            paginate: {
                                // remove previous & next text from pagination
                                previous: '&nbsp;',
                                next: '&nbsp;'
                            }
                        },
                        // Buttons with Dropdown
                        buttons: [{
                                extend: 'collection',
                                className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                                text: feather.icons['share'].toSvg({
                                    class: 'font-small-4 mr-50'
                                }) + 'تصدير',
                                buttons: [{
                                        extend: 'print',
                                        text: feather.icons['printer'].toSvg({
                                            class: 'font-small-4 mr-50'
                                        }) + 'طباعة',
                                        className: 'dropdown-item',
                                        exportOptions: {
                                            columns: [0, 1, 2, 3, 4, 5],
                                            modifier: {
                                                selected: true // تصدير الصفوف المحددة فقط
                                            }
                                        },
                                        customize: function(win) {
                                            $(win.document.body).prepend(
                                                '<h3 style="text-align:center;">جهات الاتصال</h3>'
                                            );
                                            $(win.document.body).find('table')
                                                .addClass('compact')
                                                .css('font-size', '12px');
                                        }
                                    },
                                    {
                                        extend: 'excelHtml5',
                                        text: feather.icons['file'].toSvg({
                                            class: 'font-small-4 mr-50'
                                        }) + 'اكسل',
                                        className: 'dropdown-item',
                                        exportOptions: {
                                            columns: [0, 1, 2, 3, 4, 5]
                                        }
                                    },
                                ],

                            },

                        ],

                    });
                } else {
                    toastr.warning('اختر نوع او حالة');
                }
            });
        });
    </script>
    <script>
        function confirmDelete(ordersId) {
            const form = document.getElementById('deleteorderForm');
            form.action = `/order/${ordersId}`;
            const modal = new bootstrap.Modal(document.getElementById('deleteorderModal'));
            modal.show();
        }
    </script>


    <script>

        //جلب بيانات تعديل الorder
        $(document).on('click', '.order-edit', function(e) {
            var orderId = $(this).data('id'); // Get ID

            $.ajax({
                url: "{{ route('order.edit', ':id') }}".replace(':id', orderId) ,
                method: 'GET',
                success: function(response) {
                    // تعيين المحتوى إلى المودال
                    $('#ceratModal .modal-content').html(response.modalContent);
                    const modal = new bootstrap.Modal(document.getElementById('ceratModal'));
                    modal.show();
                },
                error: function() {
                    toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                }
            });
        });


        //orderEditForm submit
        $(document).on('submit', '.orderEditForm', function(e) {
            e.preventDefault();
            var orderId = $(this).data('id'); // Get ID

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: "{{ route('order.update', ':id') }}".replace(':id', orderId) ,
                method: 'PUT',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // // عرض الأخطاء لكل حقل
                        // if (errors.phone) {
                        //     $('.error-phone').text(errors.phone[0]);
                        // }
                        // if (errors.name) {
                        //     $('.error-name').text(errors.name[0]);
                        // }
                    }
                }
            });
        });
    </script>
@endpush
