@extends('layouts.dash_master')
@section('title')
    <title>{{ __('محتويات مركز المعرفة') }}</title>
@endsection

@section('dash-content')
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">قائمة محتويات مركز المعرفة</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">الرئيسية</a>
                            </li>
                            <li class="breadcrumb-item"> {{ __('محتويات مركز المعرفة') }}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-header-right text-md-end col-md-3 col-12 d-md-block d-none">
            <div class="mb-1 breadcrumb-right">
                <a class="btn btn-primary " data-bs-toggle="modal" data-bs-target="#addnew"><i
                        class="fas fa-plus"></i> {{ __('اضف جديد') }}</a>
            </div>
        </div>
    </div>
    <div class="knowledgebases-list-wrapper">
        <!-- knowledgebases List Items -->
        <div class="row" id="basic-table">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{$kb->title_en}}</h4>
                    </div>
                    <div class="table-responsive p-3">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>العمليات</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($kb->contents as $index => $content)
                                    <tr>
                                        <td>{{ ++$index }}</td>
                                        <td>{{ $content->title_ar }}</td>

                                        <td>
                                            <div class="d-flex gap-1">
                                                <a href="javascript:void(0);" id="knowledgebase-edit" data-id="{{ $content->id }}"
                                                   class="btn btn-sm btn-icon btn-outline-primary" title="Edit">
                                                    <i data-feather="edit-2"></i>
                                                </a>
                                                <a href="javascript:void(0);" onclick="confirmDelete({{ $content->id }})"
                                                   class="btn btn-sm btn-icon btn-outline-danger" title="Delete">
                                                    <i data-feather="trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!--/ knowledgebases List Items -->

    </div>
    <!-- Delete knowledgebases Modal -->
    <div class="modal fade modal-danger text-start" id="deleteknowledgebaseModal" tabindex="-1"
        aria-labelledby="deleteknowledgebasesLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deleteknowledgebasesLabel">حذف محتوى</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
                </div>
                <div class="modal-body">
                    <p>هل انت متأكد من انك تريد حذف هذا المحتوى ؟ لايمكن التراجع عن العملية</p>
                </div>
                <div class="modal-footer">
                    <form method="POST" id="deleteknowledgebaseForm">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">اغلاق</button>
                        <button type="submit" class="btn btn-danger"> حذف</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade text-start" id="addnew" tabindex="-1"
        aria-labelledby="addnew" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="addnew">انشاء محتوى</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('knowledgebaseContents.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="rh_arabic-tab" data-bs-toggle="tab"
                                        href="#rh_arabic" aria-controls="rh_arabic" role="tab"
                                        aria-selected="true"> عربي</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="rh_english-tab" data-bs-toggle="tab"
                                        href="#rh_english" aria-controls="rh_english" role="tab"
                                        aria-selected="false"> English</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane active" id="rh_arabic" aria-labelledby="rh_arabic-tab"
                                    role="tabpanel">
                                    <x-input-field label="{{ __('العنوان') }}" name="title_ar" value="{{ old('title_ar') }}" required="true"
                                    col="12" maxLength="1000" />
                                    <x-textarea-field label="{{ __('  الوصف  ') }}" name="body_ar" value="{{ old('body_ar') }}"
                                                                    maxLength="10000" />
                                </div>
                                <div class="tab-pane" id="rh_english" aria-labelledby="rh_english-tab"
                                    role="tabpanel">
                                    <x-input-field label="{{ __('العنوان en') }}" name="title_en" value="{{ old('title_en') }}" required="true"
                                    col="12" maxLength="1000" />

                                    <x-textarea-field label="{{ __(' الوصف en') }}" name="body_en" value="{{ old('body_en') }}"
                                        maxLength="10000" />
                                </div>
                            </div>
                            <input type="hidden" value="{{$kb->id}}" name="knowledgebase_id">

                        </div>

                        <div class="row">
                            <div class="col-12">
                                <button class="btn btn-primary">{{ __('حفظ') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade text-start" id="ceratModal" tabindex="-1"
        aria-labelledby="ceratModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <!-- سيتم تحميل المحتوى هنا -->
            </div>
        </div>
    </div>
@endsection
@push('js')
    <script>
        function confirmDelete(knowledgebasesId) {
            const form = document.getElementById('deleteknowledgebaseForm');
            form.action = "{{ route('knowledgebaseContents.destroy', ':id') }}".replace(':id', knowledgebasesId);
            const modal = new bootstrap.Modal(document.getElementById('deleteknowledgebaseModal'));
            modal.show();
        }
    </script>

    <script>
        //جلب بيانات تعديل الknowledgebase
        $(document).on('click', '#knowledgebase-edit', function(e) {
            var knowledgebaseId = $(this).data('id'); // Get ID

            $.ajax({
                url: "{{ route('knowledgebaseContents.edit', ':id') }}".replace(':id', knowledgebaseId),
                method: 'GET',
                success: function(response) {
                    // تعيين المحتوى إلى المودال
                    $('#ceratModal .modal-content').html(response.modalContent);
                    $('#ceratModal').modal('show');
                },
                error: function() {
                    toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                }
            });
        });


        //knowledgebaseEditForm submit
        $(document).on('submit', '.knowledgebaseEditForm', function(e) {
            e.preventDefault();
            var knowledgebaseId = $(this).data('id'); // Get ID

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: "{{ route('knowledgebaseContents.update', ':id') }}".replace(':id', knowledgebaseId),
                method: 'PUT',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // عرض الأخطاء لكل حقل
                        if (errors.phone) {
                            $('.error-phone').text(errors.phone[0]);
                        }
                        if (errors.name) {
                            $('.error-name').text(errors.name[0]);
                        }
                    }
                }
            });
        });

    </script>
@endpush
