@extends('layouts.dash_master')
@section('title')
    <title>{{ __('faqs') }}</title>
@endsection

@section('dash-content')
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">faqs قائمة</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">الرئيسية</a>
                            </li>
                            <li class="breadcrumb-item"> {{ __('faqs') }}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-header-right text-md-end col-md-3 col-12 d-md-block d-none">
            <div class="mb-1 breadcrumb-right">
                <a class="btn btn-primary create_faq"><i
                        class="fas fa-plus"></i> {{ __('اضف جديد') }}</a>
            </div>
        </div>
    </div>
    <div class="faqs-list-wrapper">
        <!-- faqs List Items -->
        <div class="row" id="basic-table">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">faqs قائمة</h4>
                    </div>
                    <div class="table-responsive p-3">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>السؤال </th>
                                    <th>الحالة</th>
                                    <th>العمليات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($faqs as $index => $faq)
                                    <tr>
                                        <td>{{ ++$index }}</td>
                                        <td>{{ $faq->question_en }}</td>
                                        <td>
                                            @if ($faq->status == 1)
                                                <a href="javascript:;"
                                                    onclick="changefaqStatus({{ $faq->id }})">
                                                    <input type="checkbox" class="form-check-input" id="colorCheck3" checked >
                                                </a>
                                                <label class="form-check-label" for="colorCheck6">active</label>

                                            @else
                                                <a href="javascript:;"
                                                    onclick="changefaqStatus({{ $faq->id }})">
                                                    <input type="checkbox" class="form-check-input" id="colorCheck4" >
                                                </a>
                                                <label class="form-check-label" for="colorCheck6">active</label>

                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex gap-1">
                                                <a href="javascript:void(0);" id="faq-edit" data-id="{{ $faq->id }}"
                                                   class="btn btn-sm btn-icon btn-outline-primary" title="Edit">
                                                    <i data-feather="edit-2"></i>
                                                </a>
                                                <a href="javascript:void(0);" onclick="confirmDelete({{ $faq->id }})"
                                                   class="btn btn-sm btn-icon btn-outline-danger" title="Delete">
                                                    <i data-feather="trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!--/ faqs List Items -->

    </div>
    <!-- Delete faqs Modal -->
    <div class="modal fade modal-danger text-start" id="deletefaqModal" tabindex="-1"
        aria-labelledby="deletefaqsLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deletefaqsLabel">تأكيد الحذف</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
                </div>
                <div class="modal-body">
                    <p>هل انت متأكد من انك تريد حذف هذا المحتوى ؟ لايمكن التراجع عن العملية</p>
                </div>
                <div class="modal-footer">
                    <form method="POST" id="deletefaqForm">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">اغلاق</button>
                        <button type="submit" class="btn btn-danger"> حذف</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade text-start" id="ceratModal" tabindex="-1"
        aria-labelledby="ceratModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <!-- سيتم تحميل المحتوى هنا -->
            </div>
        </div>
    </div>
@endsection
@push('js')
    <script>
        function confirmDelete(faqsId) {
            const form = document.getElementById('deletefaqForm');
            form.action = "{{ route('faq.destroy', ':id') }}".replace(':id', faqsId);
            const modal = new bootstrap.Modal(document.getElementById('deletefaqModal'));
            modal.show();
        }
    </script>


    <script>
        $(document).ready(function() {
            $('.create_faq').on('click', function() {
                $.ajax({
                    url: "{{ route('faq.create') }}",
                    method: 'GET',
                    success: function(response) {
                        // تعيين المحتوى إلى المودال
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        alert('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });
        });
    </script>
    <script>
        //faqForm submit
        $(document).on('submit', '.faqForm', function(e) {
            e.preventDefault();

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: "{{ route('faq.store') }}",
                method: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد

                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // // عرض الأخطاء لكل حقل
                        // if (errors.phone) {
                        //     $('.error-phone').text(errors.phone[0]);
                        // }
                        // if (errors.name) {
                        //     $('.error-name').text(errors.name[0]);
                        // }
                    }
                }
            });
        });

        //جلب بيانات تعديل الfaq
        $(document).on('click', '#faq-edit', function(e) {
            var faqId = $(this).data('id'); // Get ID

            $.ajax({
                url: "{{ route('faq.edit', ':id') }}".replace(':id', faqId),
                method: 'GET',
                success: function(response) {
                    // تعيين المحتوى إلى المودال
                    $('#ceratModal .modal-content').html(response.modalContent);
                    $('#ceratModal').modal('show');
                },
                error: function() {
                    toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                }
            });
        });


        //faqEditForm submit
        $(document).on('submit', '.faqEditForm', function(e) {
            e.preventDefault();
            var faqId = $(this).data('id'); // Get ID

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: "{{ route('faq.update', ':id') }}".replace(':id', faqId),
                method: 'PUT',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // // عرض الأخطاء لكل حقل
                        // if (errors.phone) {
                        //     $('.error-phone').text(errors.phone[0]);
                        // }
                        // if (errors.name) {
                        //     $('.error-name').text(errors.name[0]);
                        // }
                    }
                }
            });
        });

        function changefaqStatus(id) {
            $.ajax({
                type: "put",
                data: {
                    _token: '{{ csrf_token() }}'
                },
                url: "{{ route('faq.status', ':id') }}".replace(':id', id),
                success: function(response) {
                    toastr.success(response)
                },
                error: function(err) {


                }
            })
        }
    </script>
@endpush
