@extends('Frontend.Layouts.app')
@section('title', 'Support')
@section('content')
    <!-- HEADER AREA -->
        @include('Frontend.Includes.Headers.headerOne')
    <!-- HEADER AREA END -->

    <!-- shared hosting banner -->
    <div class="rts-hosting-banner  rts-hosting-banner-bg banner-default-height">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="banner-area">
                        <div class="rts-hosting-banner rts-hosting-banner__content support__banner">
                            <span class="starting__price"  data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Hosting Support</span>
                            <h1 class="banner-title" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                                Expert And Friendly Hosting Support
                            </h1>
                            <p class="slogan" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Our support team is famous for being fast, friendly
                                and helpful. Our customers confirm.</p>
                            <div class="hosting-action mt-5" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                                <img src="{{asset ('assets/images/banner/title-shape-2.svg') }}" alt=""> <a href="#" class="btn__white"> 24/7 Hours Dedicated Support</a>
                            </div>
                        </div>
                        <div class="rts-hosting-banner__image support">
                            <img src="{{asset ('assets/images/banner/support/banner__support__image.svg') }}" alt="">
                            <img class="shape one shake-br" src="{{asset ('assets/images/banner/support/banner__support__image-sm-1.svg') }}" alt="">
                            <img class="shape two shake-tl" src="{{asset ('assets/images/banner/support/banner__support__image-sm-2.svg') }}" alt="">
                            <img class="shape three rotate-one" src="{{asset ('assets/images/banner/support/banner__support__image-sm-3.svg') }}" alt="">
                            <img class="shape four rotate-two" src="{{asset ('assets/images/banner/support/banner__support__image-sm-4.svg') }}" alt="">
                            <img class="shape five" src="{{asset ('assets/images/banner/support/banner__support__image-sm-5.svg') }}" alt="">
                            <img class="shape six rotate-one" src="{{asset ('assets/images/banner/support/banner__support__image-sm-6.svg') }}" alt="">
                            <img class="shape seven" src="{{asset ('assets/images/banner/support/banner__support__image-sm-7.svg') }}" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- shared hosting banner end-->

    <!-- ABOUT RESELLER HOSTING -->
    <div class="rts-about-reseller section__padding support">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-10" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                    <div class="image-height">
                        <div class="hosting-about-image-bg"></div>
                        <div class="hosting-about-image">
                            <div class="img-one">
                                <img src="{{asset ('assets/images/about/resell/image-1.png') }}" width="378" height="400" alt="">
                            </div>
                            <div class="img-two">
                                <img src="{{asset ('assets/images/about/resell/image-2.png') }}" width="247" height="347" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-10">
                    <div class="hosting-info">
                        <h2 class="hosting-info__title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Capable & well-
                            Prepared people</h2>
                        <p class="description" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">We make sure that the people helping our customers are really well prepared. They undergo intensive training, a long mentorship period, and get frequent feedback.</p>
                        <div class="single-about-info">
                            <div class="single" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                                <div class="icon">
                                    <img src="{{asset ('assets/images/about/resell/support.svg') }}" alt="">
                                </div>
                                <div class="content">
                                    <h6>24/7 Guru Support</h6>
                                    <p class="mb-0">
                                        Our custom control panel to use
                                        and removes the headache
                                    </p>
                                </div>
                            </div>
                            <div class="single" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                                <div class="icon">
                                    <img src="{{asset ('assets/images/about/resell/speed-meter.svg') }}" alt="">
                                </div>
                                <div class="content">
                                    <h6>Up To 20X Faster Turbo</h6>
                                    <p class="mb-0">
                                        Our custom control panel to use
                                        and removes the headache
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- ABOUT RESELLER HOSTING END -->

    <!-- PROMOTE HOSTIE -->
    <div class="rts-promote-hostie alice__blue section__padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="rts-section text-center">
                    <h3 class="rts-section__title font-40" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Features of Premium Support</h3>
                    <p class="rts-section__description" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                        We are uniquely positioned to offer the best web hosting affiliate program
                    </p>
                </div>
            </div>
            <div class="row g-30" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="card-feature">
                        <div class="card-feature__single">
                            <div class="card-feature__single--icon">
                                <svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M52.5 15H45V7.5C44.9989 6.50579 44.6034 5.55262 43.9004 4.84961C43.1974 4.1466 42.2442 3.75114 41.25 3.75H7.5C6.50579 3.75114 5.55262 4.1466 4.84961 4.84961C4.1466 5.55262 3.75114 6.50579 3.75 7.5V41.25C3.75114 42.2442 4.1466 43.1974 4.84961 43.9004C5.55262 44.6034 6.50579 44.9989 7.5 45H15V52.5C15.0011 53.4942 15.3966 54.4474 16.0996 55.1504C16.8026 55.8534 17.7558 56.2489 18.75 56.25H52.5C53.4942 56.2489 54.4474 55.8534 55.1504 55.1504C55.8534 54.4474 56.2489 53.4942 56.25 52.5V18.75C56.2489 17.7558 55.8534 16.8026 55.1504 16.0996C54.4474 15.3966 53.4942 15.0011 52.5 15ZM7.5 41.25V7.5H41.25V15H18.75C17.7558 15.0011 16.8026 15.3966 16.0996 16.0996C15.3966 16.8026 15.0011 17.7558 15 18.75V41.25H7.5ZM41.25 41.25H36.4014L18.75 23.5988V18.75H23.5986L41.2523 36.4043L41.25 41.25ZM18.75 28.9014L31.0986 41.25H18.75V28.9014ZM41.2519 31.1006L28.9014 18.75H41.25L41.2519 31.1006ZM18.75 52.5V45H41.25C42.2442 44.9989 43.1974 44.6034 43.9004 43.9004C44.6034 43.1974 44.9989 42.2442 45 41.25V18.75H52.5V52.5H18.75Z" fill="white" />
                                    <path d="M52.5 15H45V7.5C44.9989 6.50579 44.6034 5.55262 43.9004 4.84961C43.1974 4.1466 42.2442 3.75114 41.25 3.75H7.5C6.50579 3.75114 5.55262 4.1466 4.84961 4.84961C4.1466 5.55262 3.75114 6.50579 3.75 7.5V41.25C3.75114 42.2442 4.1466 43.1974 4.84961 43.9004C5.55262 44.6034 6.50579 44.9989 7.5 45H15V52.5C15.0011 53.4942 15.3966 54.4474 16.0996 55.1504C16.8026 55.8534 17.7558 56.2489 18.75 56.25H52.5C53.4942 56.2489 54.4474 55.8534 55.1504 55.1504C55.8534 54.4474 56.2489 53.4942 56.25 52.5V18.75C56.2489 17.7558 55.8534 16.8026 55.1504 16.0996C54.4474 15.3966 53.4942 15.0011 52.5 15ZM7.5 41.25V7.5H41.25V15H18.75C17.7558 15.0011 16.8026 15.3966 16.0996 16.0996C15.3966 16.8026 15.0011 17.7558 15 18.75V41.25H7.5ZM41.25 41.25H36.4014L18.75 23.5988V18.75H23.5986L41.2523 36.4043L41.25 41.25ZM18.75 28.9014L31.0986 41.25H18.75V28.9014ZM41.2519 31.1006L28.9014 18.75H41.25L41.2519 31.1006ZM18.75 52.5V45H41.25C42.2442 44.9989 43.1974 44.6034 43.9004 43.9004C44.6034 43.1974 44.9989 42.2442 45 41.25V18.75H52.5V52.5H18.75Z" fill="white" />
                                </svg>
                            </div>
                            <h5 class="card-feature__single--title">
                                Freedom of Choice
                            </h5>
                            <p class="card-feature__single--description">
                                Ample cloud hosting flexibility with 5 industry-leading
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="card-feature">
                        <div class="card-feature__single">
                            <div class="card-feature__single--icon">
                                <svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M30 0C46.5685 0 60 13.4315 60 30C60 46.5685 46.5685 60 30 60C13.4315 60 0 46.5685 0 30C0 13.4315 13.4315 0 30 0ZM30 3.15789C15.1755 3.15789 3.15789 15.1755 3.15789 30C3.15789 44.8245 15.1755 56.8421 30 56.8421C44.8245 56.8421 56.8421 44.8245 56.8421 30C56.8421 15.1755 44.8245 3.15789 30 3.15789ZM46.906 13.094C47.4751 13.6632 47.5778 14.6899 46.906 15.327L35.4413 26.7916C35.9969 27.7319 36.3158 28.8287 36.3158 30C36.3158 33.4881 33.4881 36.3158 30 36.3158C26.5119 36.3158 23.6842 33.4881 23.6842 30C23.6842 26.5119 26.5119 23.6842 30 23.6842C31.1713 23.6842 32.2681 24.0031 33.2084 24.5587L44.673 13.094C45.2896 12.4774 46.2893 12.4774 46.906 13.094ZM30 26.8421C28.2559 26.8421 26.8421 28.2559 26.8421 30C26.8421 31.7441 28.2559 33.1579 30 33.1579C31.7441 33.1579 33.1579 31.7441 33.1579 30C33.1579 28.2559 31.7441 26.8421 30 26.8421ZM48.6594 21.4359C49.8839 24.0996 50.5263 27.0059 50.5263 30C50.5263 30.872 49.8194 31.5789 48.9474 31.5789C48.0753 31.5789 47.3684 30.872 47.3684 30C47.3684 27.4636 46.8254 25.0069 45.7902 22.7548C45.4259 21.9625 45.773 21.0249 46.5653 20.6607C47.3577 20.2965 48.2952 20.6436 48.6594 21.4359ZM30 9.47368C33.0217 9.47368 35.9539 10.1281 38.6373 11.3744C39.4282 11.7417 39.7715 12.6806 39.4042 13.4715C39.0369 14.2624 38.0979 14.6058 37.3071 14.2384C35.0384 13.1847 32.5599 12.6316 30 12.6316C20.4077 12.6316 12.6316 20.4077 12.6316 30C12.6316 30.872 11.9247 31.5789 11.0526 31.5789C10.1806 31.5789 9.47368 30.872 9.47368 30C9.47368 18.6636 18.6636 9.47368 30 9.47368Z" fill="#2D3C58" />
                                </svg>
                            </div>
                            <h5 class="card-feature__single--title">
                                Good Performance
                            </h5>
                            <p class="card-feature__single--description">
                                Add social networking right into WordPress site.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="card-feature">
                        <div class="card-feature__single">
                            <div class="card-feature__single--icon">
                                <svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M46.875 18.75H46.7625C46.2854 14.6389 44.3142 10.8465 41.2236 8.09387C38.133 5.34123 34.1387 3.82031 30 3.82031C25.8613 3.82031 21.867 5.34123 18.7764 8.09387C15.6858 10.8465 13.7146 14.6389 13.2375 18.75H13.125C10.6386 18.75 8.25403 19.7377 6.49587 21.4959C4.73772 23.254 3.75 25.6386 3.75 28.125C3.75 30.6114 4.73772 32.996 6.49587 34.7541C8.25403 36.5123 10.6386 37.5 13.125 37.5H16.875V20.625C16.875 17.144 18.2578 13.8056 20.7192 11.3442C23.1806 8.88281 26.519 7.50001 30 7.50001C33.481 7.50001 36.8194 8.88281 39.2808 11.3442C41.7422 13.8056 43.125 17.144 43.125 20.625V39.375C43.1237 41.0929 42.5328 42.7583 41.4509 44.0928C40.369 45.4272 38.8618 46.3498 37.1813 46.7063C36.6807 44.9508 35.5572 43.4382 34.0212 42.4519C32.4852 41.4655 30.6422 41.0732 28.8377 41.3485C27.0332 41.6238 25.391 42.5477 24.2189 43.9471C23.0469 45.3465 22.4254 47.1254 22.471 48.9502C22.5167 50.775 23.2262 52.5206 24.4668 53.8597C25.7073 55.1988 27.3936 56.0395 29.2096 56.2242C31.0256 56.409 32.8467 55.9251 34.3315 54.8633C35.8163 53.8014 36.8628 52.2345 37.275 50.4563C39.9356 50.0618 42.3669 48.7271 44.128 46.6942C45.8892 44.6613 46.8637 42.0647 46.875 39.375V37.5C49.3614 37.5 51.746 36.5123 53.5041 34.7541C55.2623 32.996 56.25 30.6114 56.25 28.125C56.25 25.6386 55.2623 23.254 53.5041 21.4959C51.746 19.7377 49.3614 18.75 46.875 18.75ZM7.5 28.125C7.5 26.6332 8.09263 25.2024 9.14752 24.1475C10.2024 23.0926 11.6332 22.5 13.125 22.5V33.75C11.6332 33.75 10.2024 33.1574 9.14752 32.1025C8.09263 31.0476 7.5 29.6169 7.5 28.125ZM30 52.5C29.2583 52.5 28.5333 52.2801 27.9166 51.868C27.2999 51.456 26.8193 50.8703 26.5355 50.1851C26.2516 49.4999 26.1774 48.7459 26.3221 48.0184C26.4667 47.291 26.8239 46.6228 27.3484 46.0984C27.8728 45.5739 28.541 45.2168 29.2684 45.0721C29.9958 44.9274 30.7498 45.0016 31.4351 45.2855C32.1203 45.5693 32.706 46.0499 33.118 46.6666C33.5301 47.2833 33.75 48.0083 33.75 48.75C33.75 49.7446 33.3549 50.6984 32.6516 51.4017C31.9484 52.1049 30.9946 52.5 30 52.5ZM46.875 33.75V22.5C48.3668 22.5 49.7976 23.0926 50.8525 24.1475C51.9074 25.2024 52.5 26.6332 52.5 28.125C52.5 29.6169 51.9074 31.0476 50.8525 32.1025C49.7976 33.1574 48.3668 33.75 46.875 33.75Z" fill="#2D3C58" />
                                </svg>
                            </div>
                            <h5 class="card-feature__single--title">
                                24/7 Expert Support
                            </h5>
                            <p class="card-feature__single--description">
                                Easily eCommerce functionality
                                to site with woocommerce
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="card-feature">
                        <div class="card-feature__single">
                            <div class="card-feature__single--icon">
                                <svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M20.625 3.75H3.75V20.625H7.5V7.5H20.625V3.75ZM3.75 39.375V56.25H20.625V52.5H7.5V39.375H3.75ZM56.25 3.75V20.625H52.5V7.5H39.375V3.75H56.25ZM39.375 56.25H56.25V39.375H52.5V52.5H39.375V56.25ZM30.9188 9.61888L47.7938 18.9939C48.0834 19.1567 48.3245 19.3935 48.4926 19.6801C48.6606 19.9668 48.7494 20.2929 48.75 20.6251V39.3751C48.7532 39.7037 48.67 40.0273 48.5088 40.3136C48.3476 40.5999 48.1139 40.8388 47.8313 41.0064L30.9563 50.3814C30.6712 50.5459 30.3479 50.6326 30.0188 50.6326C29.6896 50.6326 29.3663 50.5459 29.0813 50.3814L12.2063 41.0064C11.9166 40.8436 11.6755 40.6068 11.5074 40.3201C11.3394 40.0335 11.2506 39.7074 11.25 39.3751V20.6251C11.2468 20.2966 11.33 19.9729 11.4912 19.6866C11.6525 19.4003 11.8861 19.1614 12.1688 18.9939L29.0438 9.61888C29.3288 9.45431 29.6521 9.36768 29.9813 9.36768C30.3104 9.36768 30.6337 9.45431 30.9188 9.61888ZM43.0125 20.6251L30 13.3876L16.9875 20.6251L30 27.8626L43.0125 20.6251ZM28.125 31.1064L15 23.8126V38.2689L28.125 45.5626V31.1064ZM31.875 31.1064V45.5626L45 38.2689V23.8126L31.875 31.1064Z" fill="#2D3C58" />
                                </svg>
                            </div>
                            <h5 class="card-feature__single--title">
                                Simplicity
                            </h5>
                            <p class="card-feature__single--description">
                                Makes it easy for your visitors to email you from your site!
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- PROMOTE HOSTIE END -->

    <!-- SHARED HOSTING FAQ -->
    <div class="rts-hosting-faq section__padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="rts-section text-center">
                        <h2 class="rts-section__title mb-0" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Frequently asked questions</h2>
                    </div>
                    <div class="rts-faq__accordion" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                        <div class="accordion accordion-flush" id="rts-accordion">
                            <div class="accordion-item active">
                                <div class="accordion-header" id="first">
                                    <h4 class="accordion-button collapse show" data-bs-toggle="collapse" data-bs-target="#item__one" aria-expanded="false" aria-controls="item__one">
                                        Why buy a domain name from hostie?
                                    </h4>
                                </div>
                                <div id="item__one" class="accordion-collapse collapse collapse show" aria-labelledby="first" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header" id="two">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__two" aria-expanded="false" aria-controls="item__two">
                                        How does domain registration work?
                                    </h4>
                                </div>
                                <div id="item__two" class="accordion-collapse collapse" aria-labelledby="two" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header" id="three">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__three" aria-expanded="false" aria-controls="item__three">
                                        Why is domain name registration required?
                                    </h4>
                                </div>
                                <div id="item__three" class="accordion-collapse collapse" aria-labelledby="three" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <div class="accordion-header" id="four">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__four" aria-expanded="false" aria-controls="item__four">
                                        Why is domain name registration required?
                                    </h4>
                                </div>
                                <div id="item__four" class="accordion-collapse collapse" aria-labelledby="four" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header" id="five">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__five" aria-expanded="false" aria-controls="item__four">
                                        Why is domain name registration required?
                                    </h4>
                                </div>
                                <div id="item__five" class="accordion-collapse collapse" aria-labelledby="five" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- SHARED HOSTING FAQ END -->

    <!-- CONTACT START -->
    <section class="rts-contact-form support pt--120 pb--120">
        <div class="container">
            <div class="row gy-30 justify-content-center">
                <div class="col-xl-6 col-lg-6 col-md-10">
                    <div class="contact-form">
                        <div class="contact-form__content" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                            <div class="contact-form__content--image">
                                <img src="{{asset ('assets/images/contact/contact-form.png') }}" width="260" height="188" alt="">
                            </div>
                            <h1 class="contact-form__content--title">
                                Ask a
                                Question
                            </h1>
                            <p class="contact-form__content--description">
                                Schedule a call today and one of our experts to help you decide which service is ideal for your business and budget.
                            </p>
                            <div class="contact__shape support-page">
                                <img src="{{asset ('assets/images/contact/contact__animated__arrow.svg') }}" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-5 col-lg-6 offset-xl-1 col-md-10">
                    <div class="form">
                        <h5>Send a message</h5>
                        <form class="form__content" method="post" action="#">
                            <div class="form__control">
                                <input type="text" class="input-form" placeholder="what is your name?" required>
                                <input type="email" class="input-form" placeholder="Email Address" required>
                            </div>
                            <div class="form__control">
                                <input type="text" class="input-form" placeholder="Phone Number" required>
                                <select name="state" id="state" class="input-form">
                                    <option value="1">state</option>
                                    <option value="1">Bangladesh</option>
                                    <option value="1">India</option>
                                    <option value="1">Pakistan</option>
                                    <option value="1">Nepal</option>
                                    <option value="1">Maldives</option>
                                </select>
                            </div>

                            <textarea name="message" cols="30" rows="10" placeholder="A brief description about your consultation" required></textarea>
                            <input type="checkbox" name="checkbox" id="checkbox">
                            <label for="checkbox">
                                By submitting your information you provide written consent
                                to hostie and its family of brands contacting you.
                            </label>
                            <button type="submit" class="submit__btn">Submit Now</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- CONTACT END -->

    <!-- HOSTIE CLIENT FEEDBACK AREA -->
    <div class="rts-client-feedback bg-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="rts-section w-500 text-center">
                    <h2 class="rts-section__title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Our Client Feedback</h2>
                    <p class="rts-section__description" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">We’re honored and humbled by the great feedback we receive from our customers on a daily basis.
                    </p>
                </div>
            </div>
            <!-- client feedback -->
            <div class="row">
                <div class="feedback-slider">
                    <div class="swiper-wrapper">
                        <!-- single slider -->
                        <div class="swiper-slide">
                            <div class="feedback-card">
                                <div class="feedback-card__border"></div>
                                <div class="feedback-card__single">
                                    <div class="quote-icon">
                                        <svg width="33" height="27" viewBox="0 0 33 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M3.12927 12.9165H11.1667C11.8905 12.9165 12.5847 13.204 13.0965 13.7159C13.6083 14.2277 13.8958 14.9219 13.8958 15.6457V23.8332C13.8958 24.557 13.6083 25.2512 13.0965 25.763C12.5847 26.2748 11.8905 26.5623 11.1667 26.5623H2.97917C2.25535 26.5623 1.56117 26.2748 1.04935 25.763C0.537536 25.2512 0.25 24.557 0.25 23.8332V14.7587C0.250828 12.2879 0.861546 9.85559 2.02796 7.67749C3.19437 5.49939 4.88041 3.6429 6.93646 2.27275L9.37906 0.635254L10.8801 2.90046L8.4375 4.53796C7.01878 5.48869 5.81394 6.72487 4.89994 8.16753C3.98594 9.61019 3.38288 11.2276 3.12927 12.9165ZM22.2328 12.9165H30.2702C30.994 12.9165 31.6882 13.204 32.2 13.7159C32.7118 14.2277 32.9993 14.9219 32.9993 15.6457V23.8332C32.9993 24.557 32.7118 25.2512 32.2 25.763C31.6882 26.2748 30.994 26.5623 30.2702 26.5623H22.0827C21.3589 26.5623 20.6647 26.2748 20.1529 25.763C19.6411 25.2512 19.3535 24.557 19.3535 23.8332V14.7587C19.3543 12.2879 19.9651 9.85559 21.1315 7.67749C22.2979 5.49939 23.9839 3.6429 26.04 2.27275L28.4962 0.635254L29.9836 2.90046L27.541 4.53796C26.1223 5.48869 24.9175 6.72487 24.0035 8.16753C23.0895 9.61019 22.4864 11.2276 22.2328 12.9165Z" fill="#4C5671" />
                                        </svg>
                                    </div>
                                    <p class="feedback-card__single--text">I am using Digital Ocean Plan in Cloud ways and I can confirm it is very good. Also, additional the backup with my hosting is awesome too.</p>
                                    <div class="feedback-card__single--author">
                                        <div class="author">
                                            <img src="{{asset ('assets/images/author/author__one.png') }}" height="50" width="50" alt="">
                                        </div>
                                        <div class="author__meta">
                                            <h6>Zayed Khan</h6>
                                            <span>Managing Director</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- single slider end -->
                        <!-- single slider -->
                        <div class="swiper-slide">
                            <div class="feedback-card">
                                <div class="feedback-card__border"></div>
                                <div class="feedback-card__single">
                                    <div class="quote-icon">
                                        <svg width="33" height="27" viewBox="0 0 33 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M3.12927 12.9165H11.1667C11.8905 12.9165 12.5847 13.204 13.0965 13.7159C13.6083 14.2277 13.8958 14.9219 13.8958 15.6457V23.8332C13.8958 24.557 13.6083 25.2512 13.0965 25.763C12.5847 26.2748 11.8905 26.5623 11.1667 26.5623H2.97917C2.25535 26.5623 1.56117 26.2748 1.04935 25.763C0.537536 25.2512 0.25 24.557 0.25 23.8332V14.7587C0.250828 12.2879 0.861546 9.85559 2.02796 7.67749C3.19437 5.49939 4.88041 3.6429 6.93646 2.27275L9.37906 0.635254L10.8801 2.90046L8.4375 4.53796C7.01878 5.48869 5.81394 6.72487 4.89994 8.16753C3.98594 9.61019 3.38288 11.2276 3.12927 12.9165ZM22.2328 12.9165H30.2702C30.994 12.9165 31.6882 13.204 32.2 13.7159C32.7118 14.2277 32.9993 14.9219 32.9993 15.6457V23.8332C32.9993 24.557 32.7118 25.2512 32.2 25.763C31.6882 26.2748 30.994 26.5623 30.2702 26.5623H22.0827C21.3589 26.5623 20.6647 26.2748 20.1529 25.763C19.6411 25.2512 19.3535 24.557 19.3535 23.8332V14.7587C19.3543 12.2879 19.9651 9.85559 21.1315 7.67749C22.2979 5.49939 23.9839 3.6429 26.04 2.27275L28.4962 0.635254L29.9836 2.90046L27.541 4.53796C26.1223 5.48869 24.9175 6.72487 24.0035 8.16753C23.0895 9.61019 22.4864 11.2276 22.2328 12.9165Z" fill="#4C5671" />
                                        </svg>
                                    </div>
                                    <p class="feedback-card__single--text">I am using Digital Ocean Plan in Cloud ways and I can confirm it is very good. Also, additional the backup with my hosting is awesome too.</p>
                                    <div class="feedback-card__single--author">
                                        <div class="author">
                                            <img src="{{asset ('assets/images/author/author__two.png') }}" height="50" width="50" alt="">
                                        </div>
                                        <div class="author__meta">
                                            <h6>Rubel Hossen</h6>
                                            <span>Managing Director</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- single slider end -->
                        <!-- single slider -->
                        <div class="swiper-slide">
                            <div class="feedback-card">
                                <div class="feedback-card__border"></div>
                                <div class="feedback-card__single">
                                    <div class="quote-icon">
                                        <svg width="33" height="27" viewBox="0 0 33 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M3.12927 12.9165H11.1667C11.8905 12.9165 12.5847 13.204 13.0965 13.7159C13.6083 14.2277 13.8958 14.9219 13.8958 15.6457V23.8332C13.8958 24.557 13.6083 25.2512 13.0965 25.763C12.5847 26.2748 11.8905 26.5623 11.1667 26.5623H2.97917C2.25535 26.5623 1.56117 26.2748 1.04935 25.763C0.537536 25.2512 0.25 24.557 0.25 23.8332V14.7587C0.250828 12.2879 0.861546 9.85559 2.02796 7.67749C3.19437 5.49939 4.88041 3.6429 6.93646 2.27275L9.37906 0.635254L10.8801 2.90046L8.4375 4.53796C7.01878 5.48869 5.81394 6.72487 4.89994 8.16753C3.98594 9.61019 3.38288 11.2276 3.12927 12.9165ZM22.2328 12.9165H30.2702C30.994 12.9165 31.6882 13.204 32.2 13.7159C32.7118 14.2277 32.9993 14.9219 32.9993 15.6457V23.8332C32.9993 24.557 32.7118 25.2512 32.2 25.763C31.6882 26.2748 30.994 26.5623 30.2702 26.5623H22.0827C21.3589 26.5623 20.6647 26.2748 20.1529 25.763C19.6411 25.2512 19.3535 24.557 19.3535 23.8332V14.7587C19.3543 12.2879 19.9651 9.85559 21.1315 7.67749C22.2979 5.49939 23.9839 3.6429 26.04 2.27275L28.4962 0.635254L29.9836 2.90046L27.541 4.53796C26.1223 5.48869 24.9175 6.72487 24.0035 8.16753C23.0895 9.61019 22.4864 11.2276 22.2328 12.9165Z" fill="#4C5671" />
                                        </svg>
                                    </div>
                                    <p class="feedback-card__single--text">I am using Digital Ocean Plan in Cloud ways and I can confirm it is very good. Also, additional the backup with my hosting is awesome too.</p>
                                    <div class="feedback-card__single--author">
                                        <div class="author">
                                            <img src="{{asset ('assets/images/author/author__one.png') }}" height="50" width="50" alt="">
                                        </div>
                                        <div class="author__meta">
                                            <h6>Ahmad Eamin</h6>
                                            <span>Laravel Developer</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- single slider end -->
                        <!-- single slider -->
                        <div class="swiper-slide">
                            <div class="feedback-card">
                                <div class="feedback-card__border"></div>
                                <div class="feedback-card__single">
                                    <div class="quote-icon">
                                        <svg width="33" height="27" viewBox="0 0 33 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M3.12927 12.9165H11.1667C11.8905 12.9165 12.5847 13.204 13.0965 13.7159C13.6083 14.2277 13.8958 14.9219 13.8958 15.6457V23.8332C13.8958 24.557 13.6083 25.2512 13.0965 25.763C12.5847 26.2748 11.8905 26.5623 11.1667 26.5623H2.97917C2.25535 26.5623 1.56117 26.2748 1.04935 25.763C0.537536 25.2512 0.25 24.557 0.25 23.8332V14.7587C0.250828 12.2879 0.861546 9.85559 2.02796 7.67749C3.19437 5.49939 4.88041 3.6429 6.93646 2.27275L9.37906 0.635254L10.8801 2.90046L8.4375 4.53796C7.01878 5.48869 5.81394 6.72487 4.89994 8.16753C3.98594 9.61019 3.38288 11.2276 3.12927 12.9165ZM22.2328 12.9165H30.2702C30.994 12.9165 31.6882 13.204 32.2 13.7159C32.7118 14.2277 32.9993 14.9219 32.9993 15.6457V23.8332C32.9993 24.557 32.7118 25.2512 32.2 25.763C31.6882 26.2748 30.994 26.5623 30.2702 26.5623H22.0827C21.3589 26.5623 20.6647 26.2748 20.1529 25.763C19.6411 25.2512 19.3535 24.557 19.3535 23.8332V14.7587C19.3543 12.2879 19.9651 9.85559 21.1315 7.67749C22.2979 5.49939 23.9839 3.6429 26.04 2.27275L28.4962 0.635254L29.9836 2.90046L27.541 4.53796C26.1223 5.48869 24.9175 6.72487 24.0035 8.16753C23.0895 9.61019 22.4864 11.2276 22.2328 12.9165Z" fill="#4C5671" />
                                        </svg>
                                    </div>
                                    <p class="feedback-card__single--text">I am using Digital Ocean Plan in Cloud ways and I can confirm it is very good. Also, additional the backup with my hosting is awesome too.</p>
                                    <div class="feedback-card__single--author">
                                        <div class="author">
                                            <img src="{{asset ('assets/images/author/author__four.png') }}" height="50" width="50" alt="">
                                        </div>
                                        <div class="author__meta">
                                            <h6>Samira Khan</h6>
                                            <span>Managing Director</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- single slider end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- HOSTIE CLIENT FEEDBACK AREA END -->

    <!-- HOSTIE CTA -->
    <div class="rts-cta-two shared-page-bg pt--120">
        <div class="container">
            <div class="row">
                <div class="rts-cta-two__wrapper">
                    <div class="cta__shape"></div>
                    <div class="cta-content">
                        <span data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Need help choosing a plan?</span>
                        <h4 data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Need help?
                            We're always here for you.</h4>
                    </div>
                    <div class="cta-btn">
                        <a href="#" class="contact__us primary__btn btn__two secondary__bg secondary__color">Go to Live chat Page</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- HOSTIE CTA END -->

    <!-- FOOTER AREA -->
    @include('Frontend.Includes.Footers.footerOne')
    <!-- FOOTER AREA END -->
@endsection
