<script src="{{asset('front/js/jquery-3.7.1.min.js')}}"></script>
<script src="{{asset('front/js/jquery.appear.js')}}"></script>
<script src="{{asset('front/js/popper/popper.min.js')}}"></script>
<script src="{{asset('front/js/bootstrap/bootstrap.min.js')}}"></script>
<!-- Page JS Implementing Plugins (Remove the plugin script here if site does not use that feature)-->
<script src="{{asset('front/js/owl-carousel/owl.carousel.min.js')}}"></script>
<script src="{{asset('front/js/swiper/swiper.min.js')}}"></script>
<script src="{{asset('front/js/swiperanimation/SwiperAnimation.min.js')}}"></script>
<script src="{{asset('front/js/shuffle/shuffle.min.js')}}"></script>
<script src="{{asset('front/js/magnific-popup/jquery.magnific-popup.js')}}"></script>
<script src="{{asset('front/js/counter/jquery.countTo.js')}}"></script>
<script src="{{asset('front/js/gsap.min.js')}}"></script>
<script src="{{asset('front/js/attractHover.js')}}"></script>
<script src="{{asset('front/js/lenis.min.js')}}"></script>
<script src="{{asset('front/js/custom.js')}}"></script> <!-- Template Scripts (Do not remove)-->
<script>
    $(document).ready(function () {
        $('.form-form').on('submit', function (e) {
            e.preventDefault();

            let form = $(this);
            let data = {
                name: form.find('input[aria-label="Name"]').val(),
                email: form.find('input[aria-label="Email"]').val(),
                phone: form.find('#phone').val(),
                type: form.find('select[name="type"]').val(),
                related_id: form.find('select[name="related_id"]').val(),
                _token: '{{ csrf_token() }}'
            };

            $.ajax({
                type: 'POST',
                url: '{{ route("front.store") }}',
                data: data,
                success: function (response) {
                    if (response.status === 'exists') {
                        Swal.fire({
                            icon: 'warning',
                            title: '{{__("lang.warning")}}',
                            text: response.message
                        });
                    } else if (response.status === 'success') {
                        Swal.fire({
                            icon: 'success',
                            title: '{{__("lang.success")}}',
                            text: response.message
                        });

                        form[0].reset();
                    }
                },
                error: function (xhr) {
                    let errors = xhr.responseJSON.errors;
                    let errorMessage = '';

                    for (let field in errors) {
                        errorMessage += errors[field][0] + '<br>';
                    }

                    Swal.fire({
                        icon: 'error',
                        title: '{{__("lang.error on data")}}',
                        html: errorMessage
                    });
                }
            });
        });
    });

    $(document).ready(function () {
        $('.contact-form').on('submit', function (e) {
            e.preventDefault();

            let form = $(this);
            let data = {
                name: form.find('input[name="name"]').val(),
                email: form.find('input[name="email"]').val(),
                phone: form.find('input[name="phone"]').val(),
                subject: form.find('input[name="subject"]').val(),
                message: form.find('textarea[name="message"]').val(),
                _token: '{{ csrf_token() }}'
            };

            $.ajax({
                type: 'POST',
                url: '{{ route("front.store.contact") }}',
                data: data,
                success: function (response) {
                    if (response.status === 'exists') {
                        Swal.fire({
                            icon: 'warning',
                            title: '{{__("lang.warning")}}',
                            text: response.message
                        });
                    } else if (response.status === 'success') {
                        Swal.fire({
                            icon: 'success',
                            title: '{{__("lang.success")}}',
                            text: response.message
                        });

                        form[0].reset();
                    }
                },
                error: function (xhr) {
                    let errors = xhr.responseJSON.errors;
                    let errorMessage = '';

                    for (let field in errors) {
                        errorMessage += errors[field][0] + '<br>';
                    }

                    Swal.fire({
                        icon: 'error',
                        title: '{{__("lang.error on data")}}',
                        html: errorMessage
                    });
                }
            });
        });
    });
</script>
