<?php

namespace App\Http\Controllers\admin;

use App\Models\Knowledgebase;
use App\Models\Company;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class KnowledgebaseController extends Controller
{
    public function index()
    {
        $knowledgebases = Knowledgebase::latest()->get();
        return view('admin.knowledgebase.knowledgebases',compact('knowledgebases'));
    }

    public function show(Knowledgebase $knowledgebase)
    {
        return view('admin.knowledgebase.show', compact('knowledgebase'));
    }

    public function create()
    {
        $modalContent = view('admin.knowledgebase.create_knowledgebase' )->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {

        // التحقق من المدخلات
        $validated = $request->validate([
            'title_ar' => 'required|string|max:255',
            'title_en' => 'required|string|max:255',
            'content' => 'nullable|string|max:10000',
            'content_en' => 'nullable|string|max:10000',
            'seo' => 'nullable|string|max:10000',
        ] );

        // إنشاء خدمة جديد
        Knowledgebase::create($validated);

        $notification = trans('Created Successfully');
        return response()->json(['redirect_url' => route('knowledgebases.index'),
        'notification' => $notification ]
    );
    }

    public function edit($id)
    {
        $knowledgebase = Knowledgebase::find($id);

        $modalContent = view('admin.knowledgebase.edit_knowledgebase',compact('knowledgebase'))->render();
        return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $knowledgebase = Knowledgebase::find($id);


        // التحقق من المدخلات
        $validated = $request->validate([
            'title_ar' => 'required|string|max:255',
            'title_en' => 'required|string|max:255',
            'content' => 'nullable|string|max:10000',
            'content_en' => 'nullable|string|max:10000',
            'seo' => 'nullable|string|max:10000',
        ] );

        // تحديث بيانات الخدمة
        $knowledgebase->update($validated);

        $notification = trans('Updated Successfully');
        return response()->json(['redirect_url' => route('knowledgebases.index'),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $knowledgebase = Knowledgebase::find($id);
        $knowledgebase->delete();
        $notification = trans('Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('knowledgebases.index')->with($notification);
    }

    public function changeStatus($id){
        $knowledgebase = Knowledgebase::find($id);
            if($knowledgebase->status== 1){
                $knowledgebase->status= 0;
                $knowledgebase->save();
                $message = trans('Inactive Successfully');
            }else{
                $knowledgebase->status= 1;
                $knowledgebase->save();
                $message= trans('Active Successfully');
            }
            return response()->json($message);
    }

    public function contents($id)
    {
        $kb = Knowledgebase::with('contents')->findOrFail($id);
        return view('admin.knowledgebase.contents', compact('kb'));
    }
}
