<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Models\Knowledgebase;
use App\Http\Controllers\Controller;
use App\Models\KnowledgebaseContent;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class ContentController extends Controller
{
    public function index()
    {
        $knowledgebaseContents = KnowledgebaseContent::latest()->get();
        return view('admin.content.knowledgebaseContents',compact('knowledgebaseContents'));
    }


    public function create()
    {
        $knowledgebases = Knowledgebase::orderBy('title_en')->pluck('title_en', 'id')->toArray();
        $modalContent = view('admin.content.create_knowledgebaseContent',compact('knowledgebases'))->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {
        $validated = $request->validate([
            'knowledgebase_id' => 'exists:knowledgebases,id',
            'title_ar' => 'required|string|max:1000',
            'title_en' => 'required|string|max:1000',
            'body_ar' => 'required|string|max:10000',
            'body_en' => 'required|string|max:10000',
            'seo' => 'nullable|string|max:10000',
        ]);
        KnowledgebaseContent::create($validated);
        $notification = trans('Created Successfully');
        return response()->json(['redirect_url' => route('content.index'),
        'notification' => $notification ]
    );
    }

    public function edit($id)
    {
        $knowledgebaseContent = KnowledgebaseContent::find($id);
        $knowledgebases = Knowledgebase::orderBy('title_en')->pluck('title_en', 'id')->toArray();

        $modalContent = view('admin.content.edit_knowledgebaseContent',compact('knowledgebaseContent','knowledgebases'))->render();
        return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $knowledgebaseContent = KnowledgebaseContent::find($id);
        $validated = $request->validate([
            'knowledgebase_id' => 'exists:knowledgebases,id',
            'title_ar' => 'required|string|max:1000',
            'title_en' => 'required|string|max:1000',
            'body_ar' => 'required|string|max:10000',
            'body_en' => 'required|string|max:10000',
            'seo' => 'nullable|string|max:10000',

        ]);
        $knowledgebaseContent->update($validated);
        $notification = trans('Updated Successfully');
        return response()->json(['redirect_url' => route('content.index'),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $knowledgebaseContent = KnowledgebaseContent::find($id);
        $knowledgebaseContent->delete();
        $notification = trans('Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('content.index')->with($notification);
    }

}
