<?php

namespace App\Http\Controllers\admin;

use App\Models\Blog;
use App\Models\Language;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class BlogController extends Controller
{
    public function index()
    {
        $blogs = Blog::latest()->get();
        return view('admin.blog.blogs',compact('blogs'));
    }

    public function show(Blog $blog)
    {
        return view('admin.blog.show', compact('blog'));
    }

    public function create()
    {
        $languages = Language::orderBy('name')->pluck('name', 'id')->toArray();

        return view('admin.blog.create',compact('languages'));

    }


    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'category' => 'required|string|max:255',
            'image' => 'nullable|mimes:jpg,jpeg,png,webp|max:2048',
            'content' => 'required|string',
            'tags' => 'nullable|string',
            'seo' => 'nullable|string|max:10000',
            'status' => 'nullable',
            'popular' => 'nullable',
            'language_id' => 'exists:languages,id',

        ]);

        if($request->hasFile('image') && $request->file('image')->isValid()){
            $validated['image'] = $request->file('image')->store('/','files');
        }
        Blog::create($validated);

        $notification = trans(' Create Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function edit($id)
    {
        $blog = blog::find($id);
        $languages = Language::orderBy('name')->pluck('name', 'id')->toArray();

        return view('admin.blog.edit',compact('blog','languages'));

    }


    public function update(Request $request,$id)
    {
        $blog = blog::find($id);
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'category' => 'required|string|max:255',
            'image' => 'nullable|mimes:jpg,jpeg,png,webp|max:2048',
            'content' => 'required|string',
            'tags' => 'nullable|string',
            'seo' => 'nullable|string|max:10000',
            'status'         => 'nullable',
            'popular'         => 'nullable',
            'language_id' => 'exists:languages,id',

        ]);
        $validated['image']= $blog->image;
        if($request->hasFile('image') && $request->file('image')->isValid()){
            if($blog->image)
                Storage::disk('files')->delete($blog->image);
            $validated['image'] = $request->file('image')->store('/','files');
        }
        $blog->update($validated);

        $notification = trans(' Update Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function destroy($id)
    {
        $blog = blog::find($id);
        if($blog->image)
                Storage::disk('files')->delete($blog->image);

        $blog->delete();
        $notification = trans('dash.Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('blog.index')->with($notification);
    }

    public function changeStatus($id){
        $blog = blog::find($id);
            if($blog->status=='active'){
                $blog->status='inactive';
                $blog->save();
                $message = trans('dash.Inactive Successfully');
            }else{
                $blog->status='active';
                $blog->save();
                $message= trans('dash.Active Successfully');
            }
            return response()->json($message);
    }


}
