<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\User\SaleController;

use App\Http\Controllers\User\UserController ;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Front\FrontController;
use App\Http\Controllers\User\AccountController;
use App\Http\Controllers\User\PurchaseController;
use App\Http\Controllers\User\TransactionController;
use App\Http\Controllers\User\ProfileController as UserProfileController;
use App\Http\Controllers\Admin\ProfileController as AdminProfileController;


// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');


require __DIR__.'/auth.php';

//admin routes
Route::group(['as'=> 'admin.', 'prefix' => 'admin', 'middleware' => ['auth', 'role:admin']],function () {

    Route::get('/dashboard',[AdminController::class,'dashboard'])->name('dashboard');

     Route::get('/profile', [AdminProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [AdminProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [AdminProfileController::class, 'destroy'])->name('profile.destroy');


});


//user routes
Route::group(['as'=> 'user.', 'middleware' => ['auth', 'role:user']],function () {

    Route::get('/profile', [UserProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [UserProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [UserProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('/dashboard',[UserController::class,'dashboard'])->name('dashboard');



    Route::resource('account', AccountController::class);
    Route::get('/accounts/{id}', [AccountController::class, 'getAccount'])->name('accounts.get');
    Route::resource('purchase', PurchaseController::class);
    Route::resource('sale', SaleController::class);
    Route::resource('transaction', TransactionController::class);
    Route::get('/transaction_suplier_create', [TransactionController::class, 'transaction_suplier_create'])->name('transaction_suplier.create');
    Route::get('/dashboard/stats', [UserController::class, 'stats'])->name('dashboard.stats');

});

Route::get('/', [FrontController::class, 'home'])->name('home');
