@extends('layouts.dash_master')
@section('title')
    <title>
        {{ __('dash.transactions') }}</title>
@endsection

@section('dash-content')
    <div class="content-header row">
        <div class="content-header-left col-md-8 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">{{ __('dash.transactions List') }}</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">{{ __('dash.Home') }}</a>
                            </li>
                            <li class="breadcrumb-item"> {{ __('dash.transactions') }}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-header-right text-md-end col-md-4 col-12 d-md-block  ">
            <div class="mb-1 breadcrumb-right">
                <a class="btn btn-primary create_transaction"><i data-feather='plus'></i> {{ __('دفعة صادرة') }}</a>
                <a class="btn btn-warning create_transaction_suplier"><i data-feather='minus'></i>
                    {{ __('دفعة واردة') }}</a>
            </div>
        </div>
        {{-- فلاتر --}}
        <div class="section-body">
            <div class="card">
                <h5 class="card-header">تصفية البيانات</h5>
                <div class="card-body row">
                    <x-select-field label="النوع " id="type" name="type" :options="[
                        'incoming' => 'الدفعات الصادرة',
                        'outgoing' => 'الدفعات الواردة',
                    ]"
                        value="{{ old('type') }}" col='3' />
                    <div class="col-md-3">
                        <label>من</label>
                        <input type="date" name="from" id="from" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label>إلى</label>
                        <input type="date" name="to" id="to" class="form-control">
                    </div>
                    <div class="col-md-3 mt-2">
                        <button type="button" name="filter" id="filter" class="btn btn-primary ">بحث</button>
                    </div>
                </div>
            </div>

            <div class="row mt-4">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive table-invoice">
                                <table class="order-list-table table table-striped text-center">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>رقم</th>
                                            <th>اسم العميل</th>
                                            <th>الهاتف</th>
                                            <th>رقم الحساب</th>
                                            <th>المبلغ المدفوع</th>
                                            <th>نوع الحواله</th>
                                            <th>تاريخ الإنشاء</th>
                                            <th>العمليات</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <div class="row mb-3 text-center">
                            <div class="col-md-6 outgoing-box">
                                <div class="alert alert-primary">
                                    💸 إجمالي المدفوعات الصادرة:
                                    <strong id="total_outgoing">0.00</strong>
                                </div>
                            </div>
                            <div class="col-md-6 incoming-box">
                                <div class="alert alert-success">
                                    💰 إجمالي المدفوعات الواردة:
                                    <strong id="total_incoming">0.00</strong>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
        <!-- Delete transactions Modal -->
        <div class="modal fade modal-danger text-start" id="deletetransactionModal" tabindex="-1"
            aria-labelledby="deletetransactionsLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-sm">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="deletetransactionsLabel">{{ __('dash.Confirm deletion') }}</h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
                    </div>
                    <div class="modal-body">
                        <p>{{ __('dash.Are you sure you want to delete this ? This action cannot be undone.') }}</p>
                    </div>
                    <div class="modal-footer">
                        <form method="POST" id="deletetransactionForm">
                            @csrf
                            @method('DELETE')
                            <button type="button" class="btn btn-secondary"
                                data-bs-dismiss="modal">{{ __('dash.Close') }}</button>
                            <button type="submit" class="btn btn-danger"> {{ __('dash.Delete') }}</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Modal -->
        <div class="modal fade text-start" id="ceratModal" tabindex="-1" aria-labelledby="ceratModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <!-- سيتم تحميل المحتوى هنا -->
                </div>
            </div>
        </div>
    @endsection
    @push('js')
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/feather-icons/4.28.0/feather.min.js"></script>

        <script>
            $(document).ready(function() {
                let table; // 👈 تعريف المتغير العام هنا

                loadData();

                function loadData(type = '', from = '', to = '') {
                    if ($.fn.DataTable.isDataTable('.order-list-table')) {
                        table.destroy(); // 👈 دمّر الجدول السابق إن وُجد
                    }

                    table = $('.order-list-table').DataTable({ // 👈 خزّنه في المتغير
                        processing: true,
                        serverSide: true,
                        ajax: {
                            url: "{{ route('user.transaction.index') }}",
                            data: {
                                type: type,
                                from: from,
                                to: to
                            }
                        },
                        columns: [{
                                data: null,
                                title: '#',
                                render: function(data, type, row, meta) {
                                    return meta.row + 1;
                                },
                                orderable: false
                            },
                            {
                                data: 'name',
                                defaultContent: '-',
                                width: '20%'
                            },
                            {
                                data: 'phone',
                                defaultContent: '-'
                            },
                            {
                                data: 'bank_account',
                                defaultContent: '-'
                            },
                            {
                                data: 'paid_amount',
                                defaultContent: '-'
                            },
                            {
                                data: 'type',
                                defaultContent: '-'
                            },
                            {
                                data: 'created_at'
                            },
                            {
                                data: 'actions',
                                orderable: false,
                                searchable: false
                            }
                        ],
                        order: [
                            [0, 'desc']
                        ],
                        dom: '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                            '<"col-lg-12 col-xl-6" l>' +
                            '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                            '>t' +
                            '<"d-flex justify-content-between mx-2 row mb-1"' +
                            '<"col-sm-12 col-md-6"i>' +
                            '<"col-sm-12 col-md-6"p>' +
                            '>',
                        language: {
                            sLengthMenu: 'إظهار _MENU_',
                            search: 'بحث:',
                            searchPlaceholder: 'بحث..',
                            paginate: {
                                previous: '&nbsp;',
                                next: '&nbsp;'
                            }
                        },
                        buttons: [{
                            extend: 'collection',
                            className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                            text: feather.icons['share'].toSvg({
                                    class: 'font-small-4 mr-50'
                                }) +
                                'تصدير',
                            buttons: [{
                                    extend: 'print',
                                    text: feather.icons['printer'].toSvg({
                                        class: 'font-small-4 mr-50'
                                    }) + 'طباعة',
                                    className: 'dropdown-item',
                                    exportOptions: {
                                        columns: [0, 1, 2, 3, 4, 5]
                                    },
                                    customize: function(win) {
                                        $(win.document.body).prepend(
                                            '<h3 style="text-align:center;">سجل  المبيعات</h3>'
                                        );
                                        $(win.document.body)
                                            .find('table')
                                            .addClass('compact')
                                            .css('font-size', '12px');
                                    }
                                },
                                {
                                    extend: 'excelHtml5',
                                    text: feather.icons['file'].toSvg({
                                        class: 'font-small-4 mr-50'
                                    }) + 'Excel',
                                    className: 'dropdown-item',
                                    exportOptions: {
                                        columns: [0, 1, 2, 3, 4, 5]
                                    }
                                }
                            ]
                        }]
                    });

                    // ✅ هذا الحدث داخل loadData بعد تعريف table
                    table.on('xhr.dt', function(e, settings, json, xhr) {
                        if (json) {
                            $('#total_outgoing').text(
                                json.total_outgoing.toLocaleString('en-US', {
                                    minimumFractionDigits: 2
                                })
                            );
                            $('#total_incoming').text(
                                json.total_incoming.toLocaleString('en-US', {
                                    minimumFractionDigits: 2
                                })
                            );
                        }
                    });
                }

                // ✅ عند الضغط على زر الفلتر
                $('#filter').click(function() {
                    var type = $('#type').val();
                    var from = $('#from').val();
                    var to = $('#to').val();
                    loadData(type, from, to);
                });
            });
        </script>
        <script>
            // === 🗑 تأكيد الحذف ===
            function confirmDeletetransaction(transactionId) {
                const form = document.getElementById('deletetransactionForm');
                form.action = "{{ route('user.transaction.destroy', ':id') }}".replace(':id', transactionId);
                const modal = new bootstrap.Modal(document.getElementById('deletetransactionModal'));
                modal.show();
            }

            // === ✏️ فتح نموذج التعديل عبر AJAX ===
            $(document).on('click', '#transaction-edit', function(e) {
                e.preventDefault();
                var transactionId = $(this).data('id');
                $.ajax({
                    url: "{{ route('user.transaction.edit', ':id') }}".replace(':id', transactionId),
                    method: 'GET',
                    success: function(response) {
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });

            // === 💾 حفظ التعديل عبر AJAX ===
            $(document).on('submit', '.transactionEditForm', function(e) {
                e.preventDefault();
                var transactionId = $(this).data('id');
                $('.text-danger').text(''); // مسح الأخطاء السابقة

                let form = $(this)[0];
                let formData = new FormData(form);
                formData.append('_token', $('meta[name="csrf-token"]').attr('content'));

                $.ajax({
                    url: "{{ route('user.transaction.update', ':id') }}".replace(':id', transactionId),
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        toastr.success(response.notification.messege || 'تم التحديث بنجاح');
                        $('#ceratModal').modal('hide');
                        $('.order-list-table').DataTable().ajax.reload(null,
                            false); // تحديث الجدول بدون إعادة تحميل الصفحة
                    },
                    error: function(xhr) {
                        toastr.error('تأكد من البيانات');
                        let errors = xhr.responseJSON.errors;
                        if (errors) {
                            $.each(errors, function(key, value) {
                                $('.error-' + key).text(value[0]);
                            });
                        }
                    }
                });
            });
        </script>
        <script>
            $(document).ready(function() {
                $('.create_transaction').on('click', function() {
                    $.ajax({
                        url: "{{ route('user.transaction.create') }}",
                        method: 'GET',
                        success: function(response) {
                            // تعيين المحتوى إلى المودال
                            $('#ceratModal .modal-content').html(response.modalContent);
                            $('#ceratModal').modal('show');
                        },
                        error: function() {
                            alert('حدث خطأ أثناء جلب بيانات الطلب.');
                        }
                    });
                });
            });
            $(document).ready(function() {
                $('.create_transaction_suplier').on('click', function() {
                    $.ajax({
                        url: "{{ route('user.transaction_suplier.create') }}",
                        method: 'GET',
                        success: function(response) {
                            // تعيين المحتوى إلى المودال
                            $('#ceratModal .modal-content').html(response.modalContent);
                            $('#ceratModal').modal('show');
                        },
                        error: function() {
                            alert('حدث خطأ أثناء جلب بيانات الطلب.');
                        }
                    });
                });
            });
            // === ✏️ فتح نموذج التعديل عبر AJAX ===
            $(document).on('click', '.view-sale', function(e) {
                e.preventDefault();
                var saleId = $(this).data('id');
                $.ajax({
                    url: "{{ route('user.sale.edit', ':id') }}".replace(':id', saleId),
                    method: 'GET',
                    success: function(response) {
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });
            $(document).on('submit', '.saleEditForm', function(e) {
                e.preventDefault();
                var saleId = $(this).data('id');
                $('.text-danger').text(''); // مسح الأخطاء السابقة

                let form = $(this)[0];
                let formData = new FormData(form);
                formData.append('_token', $('meta[name="csrf-token"]').attr('content'));

                $.ajax({
                    url: "{{ route('user.sale.update', ':id') }}".replace(':id', saleId),
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        toastr.success(response.notification.messege || 'تم التحديث بنجاح');
                        $('#ceratModal').modal('hide');
                        $('.order-list-table').DataTable().ajax.reload(null,
                            false); // تحديث الجدول بدون إعادة تحميل الصفحة
                    },
                    error: function(xhr) {
                        toastr.error('تأكد من البيانات');
                        let errors = xhr.responseJSON.errors;
                        if (errors) {
                            $.each(errors, function(key, value) {
                                $('.error-' + key).text(value[0]);
                            });
                        }
                    }
                });
            });

            // === ✏️ فتح نموذج التعديل عبر AJAX ===
            $(document).on('click', '.view-purchase', function(e) {
                e.preventDefault();
                var purchaseId = $(this).data('id');
                $.ajax({
                    url: "{{ route('user.purchase.edit', ':id') }}".replace(':id', purchaseId),
                    method: 'GET',
                    success: function(response) {
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });
            $(document).on('submit', '.purchaseEditForm', function(e) {
                e.preventDefault();
                var purchaseId = $(this).data('id');
                $('.text-danger').text(''); // مسح الأخطاء السابقة

                let form = $(this)[0];
                let formData = new FormData(form);
                formData.append('_token', $('meta[name="csrf-token"]').attr('content'));

                $.ajax({
                    url: "{{ route('user.purchase.update', ':id') }}".replace(':id', purchaseId),
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        toastr.success(response.notification.messege || 'تم التحديث بنجاح');
                        $('#ceratModal').modal('hide');
                        $('.order-list-table').DataTable().ajax.reload(null,
                            false); // تحديث الجدول بدون إعادة تحميل الصفحة
                    },
                    error: function(xhr) {
                        toastr.error('تأكد من البيانات');
                        let errors = xhr.responseJSON.errors;
                        if (errors) {
                            $.each(errors, function(key, value) {
                                $('.error-' + key).text(value[0]);
                            });
                        }
                    }
                });
            });
            //transactionForm submit
            $(document).on('submit', '.transactionForm', function(e) {
                e.preventDefault();
                // مسح الأخطاء السابقة
                $('.text-danger').text('');

                let form = $(this)[0];
                let formData = new FormData(form); // يدعم الصور والملفات

                $.ajax({
                    url: "{{ route('user.transaction.store') }}",
                    method: 'POST',
                    data: formData,
                    processData: false, // مهم جداً
                    contentType: false, // مهم جداً
                    success: function(response) {
                        toastr.success(response.notification.messege || 'تم الانشاء بنجاح');
                        $('#ceratModal').modal('hide');
                        $('.order-list-table').DataTable().ajax.reload(null,
                            false); // تحديث الجدول بدون إعادة تحميل الصفحة
                    },
                    error: function(xhr) {
                        let errors = xhr.responseJSON.errors;
                        if (errors) {
                            toastr.error('تاكد من البيانات');

                            // // عرض الأخطاء لكل حقل
                            // if (errors.phone) {
                            //     $('.error-phone').text(errors.phone[0]);
                            // }
                            // if (errors.name) {
                            //     $('.error-name').text(errors.name[0]);
                            // }
                        }
                    }
                });
            });
        </script>
    @endpush
