@if ($transaction->type == 'payment' || $transaction->type == 'sale')
    <div class="modal-header bg-primary ">
        <h4 class="modal-title text-white" id="ceratModal">{{ __('تعديل دفعة صادرة') }} </h4>
@else
    <div class="modal-header bg-warning ">
        <h4 class="modal-title text-white" id="ceratModal">{{ __('تعديل دفعة واردة') }} </h4>
@endif
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
</div>
<div class="modal-body">
    <form class="transactionEditForm" data-id="{{ $transaction->id }}" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="row">
         <x-input-field label="{{ __('الأسم كاملا') }}" name="name" value="{{ old('name', $transaction->account->name) }}" required="true"
                col="4" maxLength="200" readonly/>
            <x-input-field label="{{ __('رقم الهاتف') }}" type="number" required="true" name="phone"
                value="{{ old('phone', $transaction->account->phone) }}" col="4" maxLength="20" readonly/>
            <hr>
            @if ($transaction->type == 'sale')
                <x-input-field label="{{ __('اجمالي الفاتورة') }}" name="total_amount" value="{{ old('total_amount',$sale->total_amount) }}"
                required="true" col="4" maxLength="200" />
            @endif
            @if ($transaction->type == 'purchase')
                <x-input-field label="{{ __('اجمالي الفاتورة') }}" name="total_amount" value="{{ old('total_amount',$sale->total_amount) }}"
                required="true" col="4" maxLength="200" />
            @endif
            <x-input-field label="{{ __('المبلغ المدفوع') }}" type="number" required="true" name="paid_amount"
                value="{{ old('paid_amount', $transaction->paid_amount) }}" col="4" maxLength="20" />
            <hr>
            <x-input-field label="{{ __(' حساب البنك') }}" name="bank_account" value="{{ old('bank_account', $transaction->bank_account) }}"
                required="true" col="4" maxLength="20" readonly/>

            <hr>
            <x-textarea-field label="{{ __('ملاحظات - اختياري') }}" name="notes" value="{{ old('notes' , $transaction->notes) }}"
                col="12" maxLength="2000" />
        </div>

        <div class="row">
            <div class="col-12">
                <button class="btn btn-primary">{{ __('Save') }}</button>
            </div>
        </div>
    </form>
</div>
