<div class="modal-header bg-primary ">
    <h4 class="modal-title text-white" id="ceratModal">إنشاء فاتورة بيع </h4>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
</div>
<div class="modal-body">
    <form class="saleForm" enctype="multipart/form-data">
        @csrf
        <div class="row">
            <x-select-field label="{{ __('مورد\زبون') }}" name="account_id" class="select2 " id="account_id"
                :options="$accounts" value="{{ old('account_id') }}" col="6" />
            <div id="balance" class="col-6" style="padding-top: 30px; font-weight: bold; "></div>
            <x-input-field label="{{ __('الأسم كاملا') }}" name="name" value="{{ old('name') }}" required="true"
                col="4" maxLength="200" />
            <x-input-field label="{{ __('رقم الهاتف') }}" type="number" required="true" name="phone"
                value="{{ old('phone') }}" col="4" maxLength="20" />
            <hr>
            <x-input-field label="{{ __('اجمالي الفاتورة') }}" name="total_amount" value="{{ old('total_amount') }}"
                required="true" col="4" maxLength="200" />
            <x-input-field label="{{ __('المبلغ المدفوع') }}" type="number" required="true" name="paid_amount"
                value="{{ old('paid_amount') }}" col="4" maxLength="20" />
            <hr>
            <x-input-field label="{{ __(' حساب البنك') }}" name="bank_account" value="{{ old('bank_account') }}"
                required="true" col="4" maxLength="20" />

            <x-input-field label="{{ __('هاتف صاحب الحساب - اختياري') }}" name="phone_account"
                value="{{ old('phone_account') }}" col="4" maxLength="20" />

            <x-input-field label="{{ __('اسم صاحب الحساب - اختياري') }}" name="name_account"
                value="{{ old('name_account') }}" col="4" maxLength="200" />
            <hr>
            <x-textarea-field label="{{ __('ملاحظات - اختياري') }}" name="notes" value="{{ old('notes') }}"
                col="12" maxLength="2000" />
        </div>

        <div class="row">
            <div class="col-12">
                <button class="btn btn-primary" id="#save">{{ __('Save') }}</button>
            </div>
        </div>
    </form>


</div>
<script>
    $(document).ready(function() {
        $('.select2').select2({
            width: '100%',
            dropdownParent: $('#ceratModal')

        });
    });
</script>
<script>
    $(document).ready(function() {
        $('#account_id').on('change', function() {
            let accountId = $(this).val();

            if (accountId) {
                $.ajax({
                    url: "{{ route('user.accounts.get', ':id') }}".replace(':id', accountId),
                    type: 'GET',
                    success: function(data) {
                        // تعبئة الحقول
                        $('input[name="name"]').val(data.name);
                        $('input[name="phone"]').val(data.phone);
                        $('input[name="bank_account"]').val(data.bank_account);
                        $('input[name="phone_account"]').val(data.phone_account);
                        $('input[name="name_account"]').val(data.name_account);
                        if (data.balance > 0) {
                            $('#balance').html('  له رصيد: ' +  data.balance );
                            toastr.success('  له رصيد: ' +  data.balance );
                        } else if (data.balance < 0) {
                            $('#balance').html('⚠️ عليه دين: ' + Math.abs(data.balance));
                            toastr.warning('⚠️ عليه دين: ' + Math.abs(data.balance)  );
                        }

                    },
                    error: function() {
                        toastr.error('حدث خطأ أثناء تحميل بيانات الزبون');
                    }
                });
            } else {
                // إعادة تعيين القيم في حال لم يتم اختيار زبون
                $('input[name="name"]').val('');
                $('input[name="phone"]').val('');
                $('input[name="bank_account"]').val('');
                $('input[name="phone_account"]').val('');
                $('input[name="name_account"]').val('');
                $('#balance').html('');

            }
        });
    });
</script>
