  @extends('layouts.dash_master')
  @section('title')
      <title>{{ __('dash.Profile') }}</title>
  @endsection

  @section('dash-header')
      <div class="content-header-left col-md-9 col-12 mb-2">
          <div class="row breadcrumbs-top">
              <div class="col-12">
                  <h2 class="content-header-title float-start mb-0">{{ __('dash.Profile') }}</h2>
                  <div class="breadcrumb-wrapper">
                      <ol class="breadcrumb">
                          <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('dash.Home') }}</a>
                          </li>
                          <li class="breadcrumb-item active">{{ __('dash.Profile') }}
                          </li>
                      </ol>
                  </div>
              </div>
          </div>
      </div>
  @endsection

  @section('dash-content')
      <section>
          <div class="row">
              <div class="col-md-12">
                  <div class="card">
                      <div class="card-header">
                          <h4 class="card-title">{{ __('dash.Profile Information') }}</h4>
                      </div>
                      <div class="card-body">
                          <div class="row">
                              <form method="post" action="{{ route('admin.profile.update') }}" class="mt-6 space-y-6">
                                  @csrf
                                  @method('patch')

                                  <x-input-field label="{{ __('dash.Name') }}" name="name"
                                      value="{{ old('name', $user->name) }}" required="true" maxLength="250" />
                                  <x-input-field label="{{ __('dash.Email') }}" name="email"
                                      value="{{ old('email', $user->email) }}" required="true" type="email"
                                      maxLength="250" />

                                  <div class="row">
                                      <div class="col-12">
                                          <button class="btn btn-primary">{{ __('dash.Save') }}</button>
                                      </div>
                                  </div>
                              </form>
                          </div>
                      </div>
                  </div>
              </div>
              <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('dash.Update Password') }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <form method="post" action="{{ route('password.update') }}" class="mt-6 space-y-6">
                                @csrf
                                @method('put')

                                <x-input-field type="password" label="{{ __('dash.Current password') }}" name="current_password" required="true" maxLength="250" />
                                <x-input-field type="password" label="{{ __('dash.New Password') }}" name="password" required="true" maxLength="250" />
                                <x-input-field type="password" label="{{ __('dash.Confirm Password') }}" name="password_confirmation" required="true" maxLength="250" />

                                <div class="row">
                                    <div class="col-12">
                                        <button class="btn btn-primary">{{ __('dash.Save') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
          </div>
      </section>
  @endsection
