@extends('layouts.dash_master')

@section('title')
    <title>لوحة التحكم</title>
@endsection

@include('layouts.user_sidebar')

@section('dash-content')
    <div class="main-content">
        <section class="section">

            {{-- ======== رأس الصفحة ======== --}}
            <div class="section-header d-flex justify-content-between align-items-center">
                <div>
                    <h1> مرحباً، {{ auth()->user()->name ?? auth()->user()->name }}</h1>
                </div>
                <div>
                    <p class="text-muted mb-0">تاريخ اليوم: {{ \Carbon\Carbon::now()->format('Y-m-d') }}</p>

                </div>
            </div>
            <div class="card-body">
                <div class="row g-2"> <!-- g-2 = مسافة بين الأزرار -->
                    <div class="col-6 col-lg-3">
                        <a class="btn btn-primary w-100 create_transaction">
                            <i data-feather="plus"></i>
                            {{ __('دفعة صادرة') }}
                        </a>
                    </div>

                    <div class="col-6 col-lg-3">
                        <a class="btn btn-info w-100 create_sale">
                            <i data-feather="shopping-cart"></i>
                            {{ __('اضافة فاتورة بيع') }}
                        </a>
                    </div>

                    <div class="col-6 col-lg-3">
                        <a class="btn btn-warning w-100 create_transaction_suplier">
                            <i data-feather="minus"></i>
                            {{ __('دفعة واردة') }}
                        </a>
                    </div>

                    <div class="col-6 col-lg-3">
                        <a class="btn btn-danger w-100 create_purchase">
                            <i data-feather="box"></i>
                            {{ __('اضافة فاتورة مشتريات') }}
                        </a>
                    </div>
                </div>
            </div>

    </div>
    </div>
    <div class="card mt-2">
        <div class="card-body row">
            <div class="col-md-3">
                <label>من</label>
                <input type="date" name="from" id="from" class="form-control">
            </div>
            <div class="col-md-3">
                <label>إلى</label>
                <input type="date" name="to" id="to" class="form-control">
            </div>
            <div class="col-md-4 mt-2">
                <button type="button" name="filter" id="filter" class="btn btn-primary ">تحديث</button>
            </div>
        </div>
    </div>

    {{-- ======== كروت عامة ======== --}}
    <div class="row mt-2">

        {{-- زوار الموقع --}}
        <div class="col-lg-3 col-sm-6 col-12 mb-0">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h2 class="fw-bolder mb-0" id="total_sale_amount"> 0.00</h2>
                        <p class="card-text text-muted mb-0">اجمالي المبيعات</p>
                    </div>
                    <div class="avatar bg-light-info p-50 m-0">
                        <div class="avatar-content">
                            <i data-feather="shopping-cart" class="font-medium-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- الخدمات --}}
        <div class="col-lg-3 col-sm-6 col-12 mb-0">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h2 class="fw-bolder mb-0" id="total_purchase_amount">0.00</h2>
                        <p class="card-text text-muted mb-0">اجمالي المشتريات</p>
                    </div>
                    <div class="avatar bg-light-warning p-50 m-0">
                        <div class="avatar-content">
                            <i data-feather="box" class="font-medium-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- الأعمال --}}
        <div class="col-lg-3 col-sm-6 col-12 mb-0">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h2 class="fw-bolder mb-0" id="total_payment">0.00</h2>
                        <p class="card-text text-muted mb-0">الدفعات الصادرة</p>
                    </div>
                    <div class="avatar bg-light-success p-50 m-0">
                        <div class="avatar-content">
                            <i data-feather="plus" class="font-medium-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- الاشتراكات --}}
        <div class="col-lg-3 col-sm-6 col-12 mb-0">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h2 class="fw-bolder mb-0" id="total_suplier_payment">0.00</h2>
                        <p class="card-text text-muted mb-0">الدفعات الواردة</p>
                    </div>
                    <div class="avatar bg-light-danger p-50 m-0">
                        <div class="avatar-content">
                            <i data-feather="minus" class="font-medium-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>


    </section>
    </div>
    <!-- Modal -->
    <div class="modal fade text-start" id="ceratModal" tabindex="-1" aria-labelledby="ceratModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <!-- سيتم تحميل المحتوى هنا -->
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        // تفعيل الأيقونات
        document.addEventListener("DOMContentLoaded", function() {
            feather.replace();
        });
    </script>
    <script>
        function loadStats() {
            let from = $('#from').val();
            let to = $('#to').val();

            $.ajax({
                url: "{{ route('user.dashboard.stats') }}",
                type: 'GET',
                data: {
                    from: from,
                    to: to
                },
                beforeSend: function() {
                    $('#filter').prop('disabled', true).text('جارِ التحديث...');
                },
                success: function(response) {
                    $('#total_sale_amount').text(Number(response.total_sale_amount).toLocaleString('en-US', {
                        minimumFractionDigits: 2
                    }));
                    $('#total_purchase_amount').text(Number(response.total_purchase_amount).toLocaleString(
                        'en-US', {
                            minimumFractionDigits: 2
                        }));
                    $('#total_payment').text(Number(response.total_payment).toLocaleString('en-US', {
                        minimumFractionDigits: 2
                    }));
                    $('#total_suplier_payment').text(Number(response.total_supplier_payment).toLocaleString(
                        'en-US', {
                            minimumFractionDigits: 2
                        }));
                },
                complete: function() {
                    $('#filter').prop('disabled', false).text('تحديث');
                },
                error: function(xhr) {
                    console.error(xhr.responseText);
                    alert('حدث خطأ أثناء تحميل البيانات.');
                }
            });
        }

        $(document).ready(function() {
            feather.replace();
            loadStats();

            $('#filter').click(function() {
                loadStats();
            });
        });

        $(document).ready(function() {
            $('.create_transaction').on('click', function() {
                $.ajax({
                    url: "{{ route('user.transaction.create') }}",
                    method: 'GET',
                    success: function(response) {
                        // تعيين المحتوى إلى المودال
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        alert('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });
        });
        $(document).ready(function() {
            $('.create_transaction_suplier').on('click', function() {
                $.ajax({
                    url: "{{ route('user.transaction_suplier.create') }}",
                    method: 'GET',
                    success: function(response) {
                        // تعيين المحتوى إلى المودال
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        alert('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });
        });

        //transactionForm submit
        $(document).on('submit', '.transactionForm', function(e) {
            e.preventDefault();
            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            let form = $(this)[0];
            let formData = new FormData(form); // يدعم الصور والملفات

            $.ajax({
                url: "{{ route('user.transaction.store') }}",
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                beforeSend: function() {
                    $('#save').prop('disabled', true).text('جارِ الارسال...');
                },
                success: function(response) {
                    toastr.success(response.notification.messege || 'تم الانشاء بنجاح');
                    $('#ceratModal').modal('hide');
                    loadStats();
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // // عرض الأخطاء لكل حقل
                        // if (errors.phone) {
                        //     $('.error-phone').text(errors.phone[0]);
                        // }
                        // if (errors.name) {
                        //     $('.error-name').text(errors.name[0]);
                        // }
                    }
                }
            });
        });

        $(document).ready(function() {
            $('.create_sale').on('click', function() {
                $.ajax({
                    url: "{{ route('user.sale.create') }}",
                    method: 'GET',
                    success: function(response) {
                        // تعيين المحتوى إلى المودال
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        alert('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });
        });
        //saleForm submit
        $(document).on('submit', '.saleForm', function(e) {
            e.preventDefault();
            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            let form = $(this)[0];
            let formData = new FormData(form); // يدعم الصور والملفات

            $.ajax({
                url: "{{ route('user.sale.store') }}",
                method: 'POST',
                data: formData,
                processData: false, // مهم جداً
                contentType: false, // مهم جداً
                beforeSend: function() {
                    $('#save').prop('disabled', true).text('جارِ الارسال...');
                },
                success: function(response) {
                    toastr.success(response.notification.messege || 'تم الانشاء بنجاح');
                    $('#ceratModal').modal('hide');
                    loadStats();// تحديث الجدول بدون إعادة تحميل الصفحة
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // // عرض الأخطاء لكل حقل
                        // if (errors.phone) {
                        //     $('.error-phone').text(errors.phone[0]);
                        // }
                        // if (errors.name) {
                        //     $('.error-name').text(errors.name[0]);
                        // }
                    }
                }
            });
        });


        $(document).ready(function() {
            $('.create_purchase').on('click', function() {
                $.ajax({
                    url: "{{ route('user.purchase.create') }}",
                    method: 'GET',
                    success: function(response) {
                        // تعيين المحتوى إلى المودال
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        alert('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });
        });
        //purchaseForm submit
        $(document).on('submit', '.purchaseForm', function(e) {
            e.preventDefault();
            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            let form = $(this)[0];
            let formData = new FormData(form); // يدعم الصور والملفات

            $.ajax({
                url: "{{ route('user.purchase.store') }}",
                method: 'POST',
                data: formData,
                processData: false, // مهم جداً
                contentType: false, // مهم جداً
                beforeSend: function() {
                    $('#save').prop('disabled', true).text('جارِ الارسال...');
                },
                success: function(response) {
                    toastr.success(response.notification.messege || 'تم الانشاء بنجاح');
                    $('#ceratModal').modal('hide');
                   loadStats(); // تحديث الجدول بدون إعادة تحميل الصفحة
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // // عرض الأخطاء لكل حقل
                        // if (errors.phone) {
                        //     $('.error-phone').text(errors.phone[0]);
                        // }
                        // if (errors.name) {
                        //     $('.error-name').text(errors.name[0]);
                        // }
                    }
                }
            });
        });
    </script>
@endpush
