<!DOCTYPE html>
<html lang="ar" dir="rtl" class="loading" data-textdirection="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول | كاش كلاود لايت</title>

    <!-- BEGIN: CSS -->
    <link rel="stylesheet" href="{{ asset('backend/vendors/css/vendors-rtl.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css-rtl/bootstrap.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css-rtl/bootstrap-extended.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css-rtl/colors.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css-rtl/components.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css-rtl/themes/dark-layout.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css-rtl/themes/bordered-layout.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css-rtl/core/menu/menu-types/vertical-menu.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css-rtl/pages/authentication.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/assets/css/style-rtl.css') }}">
    <!-- END: CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('backend/css-rtl/custom-rtl.css') }}">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">

    <style>

    </style>
</head>

<body class="vertical-layout blank-page navbar-floating footer-static" data-open="click" data-menu="vertical-menu-modern" data-col="blank-page">

    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="content-wrapper">
            <div class="content-body">

                <div class="auth-wrapper auth-cover">
                    <div class="auth-inner row m-0">
                        <!-- النصف الأيسر (صورة) -->
                        <div class="d-none d-lg-flex col-lg-8 align-items-center justify-content-center p-5">
                            <img class="img-fluid" src="{{ asset('backend/images/pages/login-v2.svg') }}" alt="Login Illustration" style="max-height: 420px;">
                        </div>

                        <!-- النصف الأيمن (الفورم) -->
                        <div class="d-flex col-lg-4 align-items-center auth-bg px-2 p-lg-5">
                            <div class="col-12 col-sm-8 col-md-6 col-lg-12 px-xl-2 mx-auto">
                <x-auth-session-status class="mb-4" :status="session('status')" />
 <!-- رسالة الجلسة -->

                                <h2 class="fw-bold mb-1 text-center">تسجيل الدخول إلى النظام</h2>
                                <p class="text-center text-muted mb-2">مرحبًا بعودتك 👋</p>

                                <form class="auth-login-form mt-2" method="POST" action="{{ route('login') }}">
                                    @csrf

                                    <div class="mb-1">
                                        <label class="form-label" for="email">البريد الإلكتروني</label>
                                        <input class="form-control" id="email" type="email" name="email"
                                               value="{{ old('email') }}" required autofocus
                                               placeholder="example@email.com">
                                        @error('email')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>

                                    <div class="mb-1">
                                        <label class="form-label" for="password">كلمة المرور</label>
                                        <input class="form-control" id="password" type="password" name="password"
                                               placeholder="••••••••" required>
                                        @error('password')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>

                                    <div class="mb-1 d-flex justify-content-between align-items-center">
                                        <div class="form-check">
                                            <input class="form-check-input" id="remember-me" type="checkbox" name="remember">
                                            <label class="form-check-label" for="remember-me">تذكرني</label>
                                        </div>
                                        @if (Route::has('password.request'))
                                            <a href="{{ route('password.request') }}" class="text-primary small">نسيت كلمة المرور؟</a>
                                        @endif
                                    </div>

                                    <button type="submit" class="btn btn-primary w-100">دخول</button>

                                </form>

                                <p class="text-center mt-2 text-muted small">
                                    جميع الحقوق محفوظة © 2025 كاش كلاود لايت
                                </p>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- BEGIN: JS -->
    <script src="{{ asset('backend/vendors/js/vendors.min.js') }}"></script>
    <script src="{{ asset('backend/js/core/app-menu.js') }}"></script>
    <script src="{{ asset('backend/js/core/app.js') }}"></script>
    <!-- END: JS -->

</body>
</html>
