<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchases', function (Blueprint $table) {
            $table->id();
             // 🔗 العلاقات
            $table->foreignId('account_id')->constrained('accounts')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            // 💰 بيانات الشراء
            $table->string('invoice_number')->nullable();
            $table->decimal('total_amount', 10, 2)->default(0); // المبلغ الكلي للفاتورة
            $table->decimal('paid_amount', 10, 2)->default(0);  // المبلغ المدفوع
            $table->decimal('remaining_amount', 10, 2)->default(0); // الباقي (دين)
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchases');
    }
};
