<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('account_id')->constrained('accounts')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade'); // المستخدم الذي أجرى العملية
            $table->string('bank_account')->nullable(); // الحساب البنكي المستخدم في العملية
            $table->decimal('paid_amount', 10, 2)->default(0);  // المبلغ المدفوع
            $table->string('type')->default('sale'); // ممكن يكون 'sale' أو 'payment'
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
