<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('accounts', function (Blueprint $table) {
            $table->id();
             // ✅ الاسم العام للحساب
            $table->string('name');
            $table->enum('type', ['customer', 'supplier'])->default('customer');
            $table->string('phone')->nullable();
            $table->string('bank_account')->nullable();
            $table->string('phone_account')->nullable();
            $table->string('name_account')->nullable();
            $table->decimal('credit', 10, 2)->default(0); // له (رصيد لصالحه)
            $table->decimal('debit', 10, 2)->default(0);  // عليه (دين عليه)
            $table->decimal('balance', 10, 2)->default(0); // الفرق (credit - debit)

            $table->text('notes')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('accounts');
    }
};
