<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Purchase extends Model
{
    protected $guarded = [];

    protected static function boot()
    {
        parent::boot();

        static::created(function ($invoice) {
            $invoice->invoice_number = 'INV-' . date('ymd') . '-' . str_pad($invoice->id, 4, '0', STR_PAD_LEFT);
            $invoice->save();
        });
    }
    public function account()
    {
        return $this->belongsTo(Account::class);
    }
    public function transaction()
    {
        return $this->hasone(Transaction::class);
    }
}
