<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Account extends Model
{
        protected $guarded = [];


        public function getBalanceStatusAttribute()
        {
            if ($this->balance > 0) return "له رصيد " . $this->balance;
            if ($this->balance < 0) return "عليه " . abs($this->balance);
            return "رصيد صفر";
        }

        public function user()
        {
            return $this->belongsTo(User::class);
        }
}
