<?php

namespace App\Http\Controllers\User;

use App\Models\Service;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class ServiceController extends Controller
{
    public function index()
    {
        $services = Service::latest()->get();
        return view('user.service.services',compact('services'));
    }


    public function create()
    {
        $modalContent = view('user.service.create_service' )->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string|max:2000',
            'image' => 'nullable|image|mimes:jpg,jpeg,png,webp|max:2048',
        ]);
        if($request->hasFile('image') && $request->file('image')->isValid()){
            $validated['image'] = $request->file('image')->store('/','files');
        }
        $validated['site_id'] = auth()->user()->site->id ?? null;
        Service::create($validated);
        $notification = trans('dash.Created Successfully');
        return response()->json(['redirect_url' => route('user.service.index'),
        'notification' => $notification ]
    );
    }

    public function edit($id)
    {
        $service = Service::find($id);

        $modalContent = view('user.service.edit_service',compact('service'))->render();
        return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $service = Service::find($id);
        $validated = $request->validate([
           'title' => 'required|string|max:255',
            'description' => 'nullable|string|max:2000',
            'image' => 'nullable|image|mimes:jpg,jpeg,png,webp|max:2048',
        ]);
        if($request->hasFile('image') && $request->file('image')->isValid()){
            if($service->image)
                Storage::disk('files')->delete($service->image);
            $validated['image'] = $request->file('image')->store('/','files');
        }
        $service->update($validated);
        $notification = trans('dash.Updated Successfully');
        return response()->json(['redirect_url' => route('user.service.index'),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $service = Service::find($id);
        $service->delete();
        $notification = trans('dash.Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('user.service.index')->with($notification);
    }
    public function changeStatus($id){
        $service = Service::find($id);
            if($service->status== 'active'){
                $service->status= 'inactive';
                $service->save();
                $message = trans('dash.Inactive Successfully');
            }else{
                $service->status= 'active';
                $service->save();
                $message= trans('dash.Active Successfully');
            }
            return response()->json($message);
    }
}
