<?php

namespace App\Http\Controllers\Front;

use App\Models\Site;
use App\Models\Subscriber;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Request as SiteRequest;

class FrontController extends Controller
{
    //
    public function home(){

        return view('welcome');
      }

    public function site_show($slug) {
        $site = Site::where('slug', $slug)->with('design')->firstOrFail();
        $services = $site->services()->active()->get();
        $works = $site->works()->active()->get();
        return view('designs.' . $site->design->name , compact('site', 'services', 'works'));
    }
    public function storeRequest(Request $request, $slug)
    {
        $site = Site::where('slug', $slug)->firstOrFail();

        $validated = $request->validate([
            'field_1' => 'nullable|string|max:2000',
            'field_2' => 'nullable|string|max:2000',
            'field_3' => 'nullable|string|max:2000',
            'field_4' => 'nullable|string|max:2000',
            'field_5' => 'nullable|string|max:2000',
            'field_6' => 'nullable|string|max:2000',
        ]);

        $validated['site_id'] = $site->id;

        SiteRequest::create($validated);

        return redirect()->back()->with('success',  $site->field->success_mess ?? 'تم ارسال الطلب !' );



    }
    public function storeSubscriber(Request $request, $slug)
    {
        $site = Site::where('slug', $slug)->firstOrFail();

        $validated = $request->validate([
            'email' => 'required|email|max:255|unique:subscribers,email',
        ]);

        Subscriber::create([
            'email' => $validated['email'],
            'site_id' => $site->id,
        ]);

        return response()->json(['success' => true, 'message' => 'تم الاشتراك بنجاح 🎉']);
    }
}
